#(ly:set-option 'old-relative)

\version "2.7.40"
% Mozart's Symphony #25
% typeset by Zach Brewster-Geisz
% from Dover reproduction of Breitkopf & Hartel's Werke

\header {
 title		= "Symphony No. 25"
 subtitle	= "in G minor"
 composer	= "W. A. Mozart (1756-1791)"
 opus		= "K. 183/173dB"
 mutopiatitle	= "Symphony No. 25 in G minor"
 mutopiacomposer = "W. A. Mozart (1756-1791)"
 mutopiaopus 	= "K. 183/173dB"
 mutopiainstrument = "Orchestra"
 date 		= "1773"
 source 	= "Breitkopf & Hartel, 1880"
 style 		= "Classical"
 copyright 	= "Public Domain"
 maintainer 	= "Zachary Brewster-Geisz"
 maintainerEmail = "zach@brewstergeisz.cjb.net"
 lastupdated 	= "2002/July/21"
}
decresc =  {
  #(ly:export (make-event-chord (list (make-span-event 'DecrescendoEvent START)))) 
  \set decrescendoText = #"decresc."
  \set decrescendoSpanner = #'dashed-line
}

enddecresc =  {
  #(ly:export (make-event-chord (list (make-span-event 'DecrescendoEvent STOP)))) 
   \unset decrescendoText 
 \unset decrescendoSpanner 
}

global = {
	\time 4/4
% 	\repeat volta 2 {
	\skip 1*214 \bar "|."
% 	}
}

Key =  \key g \minor
HornKey =  \key a \minor

oboeItheme  =  { 
	g'1 d es fis, g4 r bes'16( a g fis  g4)-. | 
	r2 bes16( a g fis  g4)-. r2 c16( bes a g  a4)-. | 
	r2 c16( bes a g  a4)-. r2 d16( c bes a  bes4)-.	
}
firstUnisonTheme =  {
	g'8 g4 g g g8 d d4 d d d8 es es4 es es es8 fis, fis4 fis fis fis8 |
}
violinItheme =  {
	g8 bes d g bes16( a g fis  g4)-. g,8 bes d g bes16( a g fis  g4)-. |
	a,8 c fis a c16( bes a g  a4)-. a,8 c fis a c16( bes a g  a4)-. |
	bes,8 d g bes d16( c bes a  bes4)-.
}
unisonTheme =  {
	bes16( a g fis  g4)-. g16( f es  d) es( d c  bes) |
	c8. c16 bes8. bes16 a8. a16 g8. g16 fis4-. d'-. r2
}


oboeI =  \relative c'' {
    \repeat volta 2 {
	< s \oboeItheme >1\f
	\relative c''' \unisonTheme
	\set Staff.printPartCombineTexts = ##f
	R1*4
	g1\fp d es fis, g g' bes cis, 
	\dim
	\repeat unfold 2 { d4.( cis8 d cis d  cis) }
	\enddim
	d4\pp r d r d r r2 |
	\set Staff.printPartCombineTexts = ##t
	bes1\f bes' a4 r r2 r1 bes, bes' a4 r r2 r1 |
	r2 bes | r bes r g r g r c r c r f, r f r bes r bes r es, r es r1 |
	es4 c a f r1 bes'4 f d bes r1 bes'4 f des bes r1 |
	des4 bes g e f ges f e f f' f, r |
	R1*7
	r2 \grace {
\override Stem   #'stroke-style = #"grace"
   c'16 
  \revert Stem #'stroke-style }
 bes4(\f  a8)-. bes-. \grace {
\override Stem   #'stroke-style = #"grace"
   d16 
  \revert Stem #'stroke-style }
 c4(  bes8)-. c-.
	\grace {
\override Stem   #'stroke-style = #"grace"
   es16 
  \revert Stem #'stroke-style }
 d4(  c8)-. d-. |
	f(  es)  d-. c-. bes4 f'4 f1 ~ f2 bes,8(  bes') bes-. bes-. |
	bes(  a) g-. f-. es!(  g) g-. g-. g(  f) es-. d-. c(  es) es-. es-. |
	es(  d) f-. bes,-. d(  c) bes-. a-. bes4 r bes'2 g4 r g2 |
	\set Staff.printPartCombineTexts = ##f
	f4 bes c, a'
	\set Staff.printPartCombineTexts = ##t
	bes2 f es(  c) d(  f) |
	es(  c) bes4 bes( c  d) es( c a  fis') |
    }
    \repeat volta 2 {
        g g,( as  bes) c as( f!  d') es es,( f  g) as( f d  b') |
	c1 es d | fis g ~ g e g f gis
	\set Staff.printPartCombineTexts = ##f
	a\fp cis, |
	d gis, a4 r r2 r1 d'\fp fis, g cis, d4 r r2 |
	R1*7
	\set Staff.printPartCombineTexts = ##t
	fis,1\p\cr fis'
	\relative c'' < s\rc \oboeItheme >1\f
	\relative c''' \unisonTheme
	\set Staff.printPartCombineTexts = ##f
	R1*4
	g1\fp d es fis, g g' bes cis, 
	\decresc
	\repeat unfold 2 { d4.( cis8 d cis d  cis) }
	\enddecresc
	d4\pp r d r d r r2 |
	\set Staff.printPartCombineTexts = ##t
	<< s1\f \repeat unfold 2 { g,1\f g' fis4 r r2 R1 } >> |
	r2 bes' r bes r es, r es | r a r a r d, r d r g r g r c, r c |
	R1 c'4 a fis d R1 g4 d bes g R1 as'4 f! d b R1
	c'4 g es c R1 bes'4 g e cis d es! d cis d d' d, r |
	R1*7
	r2 << \repeat unfold 2 {
	  \grace {
\override Stem   #'stroke-style = #"grace"
   a'16 
  \revert Stem #'stroke-style }
 g4(  fis8) g-. |
	  \grace {
\override Stem   #'stroke-style = #"grace"
   bes16 
  \revert Stem #'stroke-style }
 a4(  g8) a-. \grace {
\override Stem   #'stroke-style = #"grace"
   c16 
  \revert Stem #'stroke-style }
 bes4(  a8) bes-. |
	  d(  c) bes-. a-.
        } s1\f >>
	g8-. g-. g-. g-. g(  fis) es-. d-. c(  es) es-. es-. |
	es(  d) c-. bes-. a(  c') c-. c-. c(  bes) d-. g,-. bes(  a) g-. fis-. |
	g4 r d2 c4 r g'2 ~ g4 bes a2 g d( c  a) |
	bes( d c  a) g4 bes( c  d) es( c a  fis') |
    } % repeat
    % Coda
    g^ \markup{{\large bold} "Coda."} r r2 R1*3 g1 d es2 c' bes g a, fis' |
    g4 r r2 g1 ~ g ~ g ~ g4 r r2
    \bar "|."
}
oboeII =  \relative c'' {
    \repeat volta 2 {
	< s \oboeItheme >1\f
	\relative c''' \unisonTheme
	g1 d es fis, g4 r r2
	R1*11
	bes1\f bes' a4 r r2 r1 bes, bes' a4 r r2 r1 |
	r2 d, r d r bes r bes r es r es r a, r a r d |
	r d r g, r g r1 |
	es'4 c a f r1 bes'4 f d bes r1 bes'4 f des bes r1 |
	des4 bes g e f ges f e f f' f, r |
	R1*7
	r2 \grace {
\override Stem   #'stroke-style = #"grace"
   c'16 
  \revert Stem #'stroke-style }
 bes4(  a8)-. bes-. \grace {
\override Stem   #'stroke-style = #"grace"
   d16 
  \revert Stem #'stroke-style }
 c4(  bes8)-. c-.
	\grace {
\override Stem   #'stroke-style = #"grace"
   es16 
  \revert Stem #'stroke-style }
 d4(  c8)-. d-. |
	f(  es)  d-. c-. bes4 f'4 f,1 ~ f2 bes8(  bes') bes-. bes-. |
	bes(  a) g-. f-. es!(  g) g-. g-. g(  f) es-. d-. c(  es) es-. es-. |
	es(  d) f-. bes,-. d(  c) bes-. a-. bes4 r d2 bes4 r bes2 |
	bes4 d c es d1 c2(  a) bes(  d) |
	c(  a) bes4 bes( c  d) es( c a  fis') |
    }
    \repeat volta 2 {
        g g,( as  bes) c as( f!  d') es es,( f  g) as( f d  b') |
	c1 g fis | a d bes cis ~ cis2 e4 cis d1 ~ d cis4 r r2 R1*3 |
	r4 a'(\f bes  gis) a( g! f  e) d r r2 R1*3 |
	r4 d(\f es!  cis) d( c! bes  a) g r r2 R1*5 |
	fis1 fis'
	\relative c'' < s \oboeItheme >1\f
	\relative c''' \unisonTheme
	g1 d es fis, g4 r r2
	R1*11 | << s1\f \repeat unfold 2 { g1\f g' fis4 r r2 R1 } >> |
	r2 d' r d r g, r g | r c r c r f,! r f r bes r bes r es, r es |
	R1 c''4 a fis d R1 g4 d bes g R1 as'4 f! d b R1
	c'4 g es c R1 bes'4 g e cis d es! d cis d d' d, r |
	R1*7
	r2 << \repeat unfold 2 {
	  \grace {
\override Stem   #'stroke-style = #"grace"
   a'16 
  \revert Stem #'stroke-style }
 g4(  fis8) g-. |
	  \grace {
\override Stem   #'stroke-style = #"grace"
   bes16 
  \revert Stem #'stroke-style }
 a4(  g8) a-. \grace {
\override Stem   #'stroke-style = #"grace"
   c16 
  \revert Stem #'stroke-style }
 bes4(  a8) bes-. |
	  d(  c) bes-. a-.
        } s1\f >>
	g8-. g-. g-. g-. g(  fis) es-. d-. c(  es) es-. es-. |
	es(  d) c-. bes-. a(  c') c-. c-. c(  bes) d-. g,-. bes(  a) g-. fis-. |
	g4 r bes,2 c4 r c2 bes4 g'2 fis4 g2 bes,( a  fis) |
	g( bes a  fis) g4 bes( c  d) es( c a  fis') |
    } % repeat
    % Coda
    g r r2 R1*3 g1 d es2 c' bes g a, fis' |
    g4 r r2 g1 ~ g ~ g ~ g4 r r2
}
corniBI =  \relative c'' {
    \repeat volta 2 {
	R1*4 r2 c\f r c r d r d r e4 c | c r r2
	\set Staff.printPartCombineTexts = ##f
	d4 c r2 e,4-. e-. r2 |
	c'1 ~ c d e e,4 r r2 |
	R1*11
	\set Staff.printPartCombineTexts = ##t
	c'4\f r r2 r1 g f' e4 c8 c c4 r e c8 c c4 r g1 f' e4 c8 c c4 r |
	e c8 c c4 r c r r2 c4 r r2 d4 d8 d d4 r d d8 d d4 r |
	e e8 e e4 r e e8 e e4 r c c8 c c4 r c c8 c c4 r |
	d d8 d d4 r d d8 d d4 r r1 |
	f4 d g,2 r1 c4 g e c r1 c'4 g c,2 r1
	c g'4 r r2 g4 g g r |
	R1*8
	g1\f ~ g2 c4 r8 c d4 r8 d e4 r8 e g f e d c4 r |
	R1*3
	c4 r c2 c4 r c2 c4 e d d c r r c, g' r r g c, r r c |
	g' r r g c, r r2 R1 |
    }
    \repeat volta 2 {
        \set Staff.printPartCombineTexts = ##f
        R1*2 c4 r r2 R1*5 | c'4 r r2 c4 r r2 c,4 r r2 r1 e'4 r r2 e4 r r2 |
	R1*18
	d1\p\< ~ d  c4\!\f r r2 R1*3 |
	r2 c\f r c r d r d r e4 c | c r r2 d4 c r2 e,4-. e-. r2 |
	c'1 ~ c d e e,4 r r2 |
	R1*11 |
	e4\f r r2 R1 e1 d' |
	c4 r r2 c4 r r2
	\set Staff.printPartCombineTexts = ##t
	e,1 d' c4 r r2 c4 r r2 d4 r r2 d4 r r2 |
	\repeat unfold 2 { d4 d8 d d4 r }
	\repeat unfold 4 { c4 c8 c c4 r }
	\repeat unfold 2 { d4 d8 d d4 r }
	R1 d4 d e,2 R1 r4 e c2 R1 g'4 g g2 R1*3 c1 e4 r r2 e4 e e r |
	R1*7 r2 c4\f r |
	\set Staff.printPartCombineTexts = ##f
	d r e r d r c r8 c d4 r8 d e4 r8 e d4 r8 d c4 r |
%	\set Staff.printPartCombineTexts = ##t
	R1*3 c4 r e2 |
	d4 r d2 c4 r r e \repeat unfold 2 { c r r c d r r d }
	c r r2 R1
    } % repeat
    % Coda
    e,4 r r2 R1*5 d'2 e e c d e |
    e4 r r2 R1 e2 c4 r e, r c r R1
}
corniBII =  \relative c' {
    \repeat volta 2 {
	R1*4 r2 e r e r e r e r e4 c c r r2 | d'4 c r2 e,4-. e-. r2 |
	e1 ~ e d' e, e4 r r2 |
	R1*11
	g4 r r2 r1 g f' e4 c c, r e c8 c c4 r g'1 f' e4 c c, r |
	e c8 c c4 r c r r2 c4 r r2 d'4 d8 d d4 r d d8 d d4 r |
	g, g8 g g4 r g g8 g g4 r e e8 e e4 r e e8 e e4 r |
	d' d8 d d4 r d d8 d d4 r r1 |
	f4 d g,2 r1 c4 g e c r1 c'4 g c,2 r1
	c g'4 r r2 g4 g g r |
	R1*8
	g1 ~ g2 e4 r8 e g4 r8 g c4 r8 c e d c g c,4 r |
	R1*3
	e4 r c2 c4 r c2 c4 c' c g e r r c g' r r g c, r r c |
	g' r r g c, r r2 R1 |
    }
    \repeat volta 2 {
        R1*2 c4 r r2 R1*5 | e4 r r2 e4 r r2 c4 r r2 r1 g'4 r r2 g4 r r2 |
	R1*18
	e1 ~ e e4 r r2 R1*3 |
	r2 e r e r e r e r e4 c c r r2 | d'4 c r2 e,4-. e-. r2 |
	e1 ~ e d' e, e4 r r2 |
	R1*11 | c4\f r r2 R1 e1 d'
	c4 r r2 c,4 r r2 e1 d' c4 r r2 c,4 r r2 d'4 r r2 d4 r r2 |
	\repeat unfold 4 { g,4 g8 g g4 r }
	\repeat unfold 2 { c,4 c8 c c4 r }
	\repeat unfold 2 { d'4 d8 d d4 r }
	R1 d4 d e,2 R1 r4 e c2 R1 g'4 g g2 R1*3 c,1 e4 r r2 e4 e e r |
	R1*7 r2 e ~ e1 ~ e ~ e ~ e2 r R1*3 e4 r c'2
	d4 r d2 c4 r r e, \repeat unfold 4 { e r r e }
	e r r2 R1
    } % repeat
    % Coda
    c4 r r2 R1*5 d'2 d c c d e |
    c4 r r2 R1 e2 c4 r e, r c r R1
}
corniGI =  \relative c'' {
    \repeat volta 2 {
	R1*4 r2 c\f r c r d r d r g,4 r r c c r r2 d4 c g-. g-. r2 |
	R1*4 c,1 ~ \repeat unfold 6 { c ~ } c
	\dim g ~ g ~ \enddim g4\pp r g r g r r2 |
	g'4\f r r2 R1*3 g4 r r2 g4 r r2 r1 r g4 r r2 |
	g4 r r2 c4 c8 c c4 r c c8 c c4 r |
	\repeat unfold 4 { d d8 d d4 r }
	\repeat unfold 4 { c4 c8 c c4 r }
	R1*34
    }
    \repeat volta 2 {
        c4\f r r2 R1 c,4 r r2 R1 c'4 r r2 c4 r r2 d4 r r2 |
	d4 r r2 c4 r r2 c4 r r2 c4 r r2 d4 r r2 d4 r r2 g,4 r r2 d'4 r r2 |
	R1*5 g,4 r r2 R1*5 c,4 r r2 R1*5 |
	d'1\p\< ~ d  c4\!\f r r2 R1*3 |
	r2 c\f r c r d r d r g,4 r r c c r r2 d4 c g-. g-. r2 |
	R1*4 c,1 ~ \repeat unfold 6 { c ~ } c
	\decresc g ~ g ~ \enddecresc g4\pp r g r g r r2 |
	c'4\f r r2 R1 
	\repeat unfold 2 { g1 f' r4 c8 c c4 r r c8 c c4 r } |
	c4 c8 c c4 r c c8 c c4 r |
	d r r2 d4 r r2 \repeat unfold 2 { g,4 g8 g g4 r }
	\repeat unfold 2 { c4 c8 c c4 r }
	\repeat unfold 2 { d4 d8 d d4 r }
	R1 f4 d g,2 R1 c4 g c,2 R1 g'4 g g2 R1 c R c g4 r r2 g4 g g r |
	R1*7 r2 c4\f r |
	d r c r d g g r8 c, d4 r8 d c4 r8 c d4 g g r |
	R1*3 c,4 r c2 ~ c4 r c2 ~ c4 r r d c r r c, |
	g' r r g c, r r c g' r r g c r r2 R1
    } % repeat
    % Coda
    c4 r r2 R1*3 c1 g c2 d c c d d |
    c4 r r2 c4 c8. c16 c4 c g'2 r4 c, g c r g c, r r2 |
}
corniGII =  \relative c' {
    \repeat volta 2 {
	R1*4 r2 c r c r g' r g r g4 r r c, c r r2 d'4 c  g-. g-. r2 |
	R1*4 c,1 ~ \repeat unfold 6 { c ~ } c
	g ~ g ~ g4 r g r g r r2 |	
	g'4 r r2 R1*3 g4 r r2 g4 r r2 r1 r g4 r r2 |
	g4 r r2 c,4 c8 c c4 r c c8 c c4 r d' d8 d d4 r d d8 d d4 r |
	g, g8 g g4 r g g8 g g4 r | c, c8 c c4 r c c8 c c4 r |
	c' c8 c c4 r c c8 c c4 r
	R1*34
    }
    \repeat volta 2 {
        c,4 r r2 R1 c4 r r2 R1 c4 r r2 c4 r r2 g'4 r r2 |
	g4 r r2 c,4 r r2 c4 r r2 c4 r r2 c'4 r r2 g4 r r2 g4 r r2 c4 r r2 |
	R1*5 g4 r r2 R1*5 c,4 r r2 R1*5 |
	g'1 ~ g c,4 r r2 R1*3 |
	r2 c r c r g' r g r g4 r r c, c r r2 d'4 c  g-. g-. r2 |
	R1*4 c,1 ~ \repeat unfold 6 { c ~ } c
	g ~ g ~ g4 r g r g r r2 |
	c4\f r r2 R1
	\repeat unfold 2 { g'1 f' r4 c8 c c4 r r c,8 c c4 r } |
	c4 c8 c c4 r c c8 c c4 r |
	d' r r2 d4 r r2 \repeat unfold 2 { g,4 g8 g g4 r }
	\repeat unfold 2 { c,4 c8 c c4 r }
	\repeat unfold 2 { d'4 d8 d d4 r }
	R1 f4 d g,2 R1 c4 g c,2 R1 g'4 g g2 R1 c, R c g4 r r2 g4 g g r |
	R1*7 r2 g' ~ g1 ~ g ~ g ~ g2 c,4 r |
	R1*3 c4 r c2 ~ c4 r c2 ~ c4 r r g'
	\repeat unfold 2 { c, r r c g' r r g }
	c, r r2 R1
    } % repeat
    % Coda
    c4 r r2 R1*3 c'1 g c,2 g' c, c c' g |
    c,4 r r2 c'4 c8. c16 c4 c g'2 r4 c, g c r g c, r r2 |
}
violinI =  \relative c'' {
    \repeat volta 2 {
	< s \firstUnisonTheme >1\f
	\violinItheme
	\unisonTheme
	\relative c'' \firstUnisonTheme
	g4 d\p d d r d d d r es es es r c c c r bes bes bes r d d d r g g g |
	r bes bes g
	\dim
	\repeat unfold 2 { fis4.( g8 fis g fis  g) }
	\enddim
	fis4\pp r fis r fis r r2
	<< s1\f
	\repeat unfold 2 {
		bes bes' a32( g  f8.) f8-. f-. f4-. r |
		a32( g  f8.) f8-. f-. f4-. r
	} >>
	bes4:16 d: f: bes: d: bes: f: d: |
	g8 g4 g g g8 ~ g g4 g g g8 | a,4: c: es: a: c: a: es: c: |
	f8 f4 f f f8 ~ f f4 f f f8 | g,4: bes: d: g: bes: g: d: bes: |
	es8 es4 es es es8 ~ es es4 es es es8 | es'4: c: a: f: es: c: a: f: |
	d'': bes: f: d: bes: f: d: bes: | des'': bes: f: des: bes: f:  des: bes: |
	des'': bes: g: e: | 
	des: bes: g: e: f: ges: f: e: f f' f, r |
	<< s1\p
	\repeat unfold 2 {
		\grace {
\override Stem   #'stroke-style = #"grace"
   c'16( 
  \revert Stem #'stroke-style }
  bes4)(  a8)-. bes-. \grace {
\override Stem   #'stroke-style = #"grace"
   d16( 
  \revert Stem #'stroke-style }
  c4)(  bes8)-. c-. |
		\grace {
\override Stem   #'stroke-style = #"grace"
   es16( 
  \revert Stem #'stroke-style }
  d4)(  c8)-. d-. \grace {
\override Stem   #'stroke-style = #"grace"
   f16( 
  \revert Stem #'stroke-style }
  es4)(  d8)-. c-. |
	} % repeat
	>>
	bes(  bes') bes-. bes-. bes(  a) g-. f-. es(  g) g-. g-. g(  f) es-. d-. |
	c(  es) es-. es-. es(  d) f-. bes,-. d(  c) bes-. a-.
	<< s2\f 
	\repeat unfold 2 {
	\grace {
\override Stem   #'stroke-style = #"grace"
   c16 
  \revert Stem #'stroke-style }
 bes4(\f  a8)-. bes-. \grace {
\override Stem   #'stroke-style = #"grace"
   d16 
  \revert Stem #'stroke-style }
 c4(  bes8)-. c-.
	\grace {
\override Stem   #'stroke-style = #"grace"
   es16 
  \revert Stem #'stroke-style }
 d4(  c8)-. d-. |
	f(  es)  d-. c-. } >>
	bes(  bes') bes-. bes-. |
	bes(  a) g-. f-. es!(  g) g-. g-. g(  f) es-. d-. c(  es) es-. es-. |
	es(  d) f-. bes,-. d(  c) bes-. a-. |
	bes c16 d es f g a bes4 r g,8 a16 bes c d es f g4 r |
	f <d bes'> c <c a'> |
	bes': f: d: bes: a: c: f: a: bes: f: d: bes: |
	a: c: f: a: bes: bes,: c: d: es: c: a: fis':
    }
    \repeat volta 2 {
        g g,:16 as: bes: c: as: f!: d': es es,: f: g: as: f: d: b': |
	c g es' r8 g, c4 g es' r8 c d4 a! fis' r8 a, |
	d4 a fis' r8 d g4 d bes' r8 d, g4 d bes' r8 d, cis4 g e' r8 e |
	g4 a, e'' r8 g, f4 a, d' r8 d, f4 d, d'' r8 gis, a4 e,\p e e r g g g |
	r f f f r f f f e a:\f bes: gis: a: g!: f: e: d a'\p a a |
	r c c c r bes bes bes r bes bes bes a d,:\f es!: cis: d: c!: bes: a:
	g8 d''-. d(  es!) es2 r8 cis-. cis(  d) d2 |
	\repeat unfold 2 { r8 b-. b(  c) c2 }
	\repeat unfold 2 { r8 g'-. g(  fis) fis2 }
	R1*2 |
	\relative c'' < s \firstUnisonTheme >1\f
	\violinItheme
	\unisonTheme
	\relative c'' \firstUnisonTheme
	g4 d\p d d r d d d r es es es r c c c r bes bes bes r d d d r g g g |
	r bes bes g
	\decresc
	\repeat unfold 2 { fis4.( g8 fis g fis  g) }
	\enddecresc
	fis4\pp r fis r fis r r2
	<< s1\f
	  \repeat unfold 2 
           { g1 g' \repeat unfold 2 { fis32( es  d8.) d8-. d-. d4-. r } }
	>>
	g4:16 bes: d: g: bes: g: d: bes:
	es8 es4 es es es8 ~ es es4 es es es8 |
	f,!4: a: c: f!: a: f: c: a: d8 d4 d d d8 ~ d d4 d d d8 |
	es,4: g: bes: es: g: es: bes: g:
	c8 c4 c c c8 ~ c c4 c c c8 |
	c'4: a: fis: d: c: a: fis: d: bes'': g: d: bes: g: d: bes: g: |
	as'': f!: d: b: as: f!: d: b: c'': g: es: b: c: g: es: c: |
	bes''!: g: e: cis: bes!: g: e: cis: d: es!: d: cis: d d' d, r |
	<< \repeat unfold 2 {
	     \grace {
\override Stem   #'stroke-style = #"grace"
   a'16 
  \revert Stem #'stroke-style }
 g4(  fis8)-. g-. \grace {
\override Stem   #'stroke-style = #"grace"
   bes16 
  \revert Stem #'stroke-style }
 a4(  g8)-. a-. |
	     \grace {
\override Stem   #'stroke-style = #"grace"
   c16 
  \revert Stem #'stroke-style }
 bes4(  a8)-. bes-. \grace {
\override Stem   #'stroke-style = #"grace"
   d16 
  \revert Stem #'stroke-style }
 c4(  bes8)-. a-. |
          }
	s1\p >>
	g8(  g') g-. g-. g(  fis) es-. d-. c(  es) es-. es-. es(  d) c-. bes-. |
	a(  c) c-. c-. bes(  d) g-. bes-. bes(  a) g-. fis-.
	<< \repeat unfold 2 {
	  \grace {
\override Stem   #'stroke-style = #"grace"
   a16 
  \revert Stem #'stroke-style }
 g4(  fis8) g-. |
	  \grace {
\override Stem   #'stroke-style = #"grace"
   bes16 
  \revert Stem #'stroke-style }
 a4(  g8) a-. \grace {
\override Stem   #'stroke-style = #"grace"
   c16 
  \revert Stem #'stroke-style }
 bes4(  a8) bes-. |
	  d(  c) bes-. a-.
        } s1\f >>
	g8-. g-. g-. g-. g(  fis) es-. d-. c(  es) es-. es-. |
	es(  d) c-. bes-. a(  c') c-. c-. c(  bes) d-. g,-. bes(  a) g-. fis-. |
	g16( a bes a g a bes a  g4) r |
	c,16( d es d c d es d  c4) r bes <bes g'> a <d, a' fis'>
	\repeat unfold 2 { g':16 d: bes: g: fis: a: d: fis: }
	g: bes,: c: d: es: c: a: fis': |
    } % repeat
    % Coda
    g8 g4 g g g8 d d4 d d d8 es es4 es es es8 b b4 b b b8 |
    c c4 c c c8 f! f4 f f f8 es es4 es8 c' c4 c8 |
    bes bes4 bes8 g g4 g8 a, a4 a8 fis' fis4 fis8 |
    g4 g,,8. g16 g4 g
    \repeat unfold 3 {
       g16( \repeat unfold 3 { a bes a g } a bes  a)
   }
   g4 r r2
}
violinII =  \relative c'' {
    \repeat volta 2 {
	<s \firstUnisonTheme>1\f
	\violinItheme
	\unisonTheme
	\relative c'' \firstUnisonTheme
	g4 bes,\p bes bes r bes bes bes r c c c r a a a r g g g r bes bes bes |
	r cis cis cis r g' g g, 
	\dim
	\repeat unfold 2 { a4.( bes8 a bes a  bes) }
	\enddim
	a4\pp r a r a r r2 |
	<< { f'!2:16\f f: f: f: f: f: f: f: f: f: f: f: f: f: f: f: }
	  { d2:16 d: d: d: a: a: a: a: d: d: d: d: a: a: a: a: }
	>> <bes, f' bes>4 r r2 |
	r1 es4: g: bes: es: g: es: bes: g: |
	c,8 c4 c c c8 ~ c c4 c c c8 | d4: f: a:  d: f: d: a: f: |
	bes,8 bes4 bes bes bes8 ~ bes bes4 bes bes bes8 |
	c4: es: g: c: es: c: g: es: | es''4: c: a: f: es: c: a: f: |
	d'': bes: f: d: bes: f: d: bes: |
	des'': bes: f: des: bes: f:  des: bes: |
	des'': bes: g: e: |
	des: bes: g: e: f: ges: f: e: f f' f, r |
	bes,\p bes2 bes4 ~ bes bes2 bes4 ~ bes bes2 bes4 ~ bes bes2 bes4 ~
	bes8(  bes') bes-. bes-. bes(  a) g-. f-. es(  g) g-. g-. g(  f) es-. d-. |
	c(  es) es-. es-. es(  d) f-. bes,-. d(  c) bes-. a-.
	<< s2\f 
	\repeat unfold 2 {
	\grace {
\override Stem   #'stroke-style = #"grace"
   c16 
  \revert Stem #'stroke-style }
 bes4(\f  a8)-. bes-. \grace {
\override Stem   #'stroke-style = #"grace"
   d16 
  \revert Stem #'stroke-style }
 c4(  bes8)-. c-.
	\grace {
\override Stem   #'stroke-style = #"grace"
   es16 
  \revert Stem #'stroke-style }
 d4(  c8)-. d-. |
	f(  es)  d-. c-. } >>
	bes(  bes') bes-. bes-. |
	bes(  a) g-. f-. es!(  g) g-. g-. g(  f) es-. d-. c(  es) es-. es-. |
	es(  d) f-. bes,-. d(  c) bes-. a-. |
	bes c16 d es f g a bes4 r g,8 a16 bes c d es f g4 r |
	f <d bes'> g <f es'> |
	<< { f8 f4 f f f8 ~ f f4 f f f8 ~ f f4 f f f8 ~ | f f4 f f f8 |
            f4 }
	 { d'8 d4 d d d8(  es) es4 es es es8(  d) d4 d d d8( |  es) es4 es es es8|
           d4 }
	>>
	bes: c: d: es: c: a: fis':
    }
    \repeat volta 2 {
        g g,:16 as: bes: c: as: f!: d': es es,: f: g: as: f: d: b': |
	c8 \repeat unfold 15 { g }
	a! \repeat unfold 15 { a }
	\repeat unfold 8 { d }
	\repeat unfold 8 { bes }
	\repeat unfold 16 { g }
	f \repeat unfold 7 { a }
	\repeat unfold 8 { gis }
	a4 cis,\p cis cis r e e e |
	r d d d r d d d cis a':\f bes: gis: a: g!: f: e: d f\p f f |
	r a a a r g g g r g g g fis d:\f es!: cis: d: c!: bes: a: |
	g r r8 bes'-. bes(  a) a2 r8 as-. as(  g) |
	g2 r8 g-. g(  fis) fis2 r8 g-. g(  a!) a2 r8 es'-. es(  d) |
	c2 r8 es,-. es(  d) c2 r2 R1
	\relative c'' <s \firstUnisonTheme>1\f
	\violinItheme
	\unisonTheme
	\relative c'' \firstUnisonTheme
	g4 bes,\p bes bes r bes bes bes r c c c r a a a r g g g r bes bes bes |
	r cis cis cis r g' g g, 
	\decresc
	\repeat unfold 2 { a4.( bes8 a bes a  bes) }
	\enddecresc
	a4\pp r a r a r r2 |
	<< { d2:16\f d: d: d: d: d: fis: fis: g: g: |
            d: d: d: d: fis: fis: | g4 }
	  { bes,2:16 bes: bes: bes: c: c: a: a: bes: bes:
            bes: bes: c: c: a: a: | bes4 }
	>>
	r4 r2 R1 c,4: es: g: c: es: c: g: es: |
	a,8 a4 a a a8 ~ a a4 a a a8 bes4: d: f!: bes: d: bes: f: d: |
	g,8 g4 g g g8 ~ g g4 g g g8 a4: c: es: a: c: a: es: c: |
	c''4: a: fis: d: c: a: fis: d: bes'': g: d: bes: g: d: bes: g: |
	as'': f!: d: b: as: f!: d: b: c'': g: es: b: c: g: es: c: |
	bes''!: g: e: cis: bes!: g: e: cis: d: es!: d: cis: d d' d, r |
	g,4\p g2 g4 ~ g g2 g4 ~ g g2 g4 ~ g g2 g4 ~
	g8(  g') g-. g-. g(  fis) es-. d-. c(  es) es-. es-. es(  d) c-. bes-. |
	a(  c) c-. c-. bes(  d) g-. bes-. bes(  a) g-. fis-.
	<< \repeat unfold 2 {
	  \grace {
\override Stem   #'stroke-style = #"grace"
   a16 
  \revert Stem #'stroke-style }
 g4(  fis8) g-. |
	  \grace {
\override Stem   #'stroke-style = #"grace"
   bes16 
  \revert Stem #'stroke-style }
 a4(  g8) a-. \grace {
\override Stem   #'stroke-style = #"grace"
   c16 
  \revert Stem #'stroke-style }
 bes4(  a8) bes-. |
	  d(  c) bes-. a-.
        } s1\f >>
	g8-. g-. g-. g-. g(  fis) es-. d-. c(  es) es-. es-. |
	es(  d) c-. bes-. a(  c') c-. c-. c(  bes) d-. g,-. bes(  a) g-. fis-. |
	g16( a bes a g a bes a  g4) r
	c,16( d es d c d es d  c4) r bes <g' bes> a <d, c'> |
	<< \repeat unfold 4 { d8 d4 d d d8 }
	  \repeat unfold 2 { bes'8 bes4 bes bes bes8 c c4 c c c8 }
	>>
	< d bes' >4 bes':16 c: d: es: c: a: fis': |
    } % repeat
    % coda
    g8 g4 g g g8 d d4 d d d8 es es4 es es es8 b b4 b b b8 |
    c c4 c c c8 f! f4 f f f8 es es4 es8 c' c4 c8
    bes bes4 bes8 g g4 g8 a, a4 a8 fis' fis4 fis8 |
    g4 g,,8. g16 g4 g
    \repeat unfold 3 {
       g16( \repeat unfold 3 { a bes a g } a bes  a)
   }
   g4 r r2
}
viola =  \relative c' {
    \repeat volta 2 {
	<s \firstUnisonTheme>1\f
	g4 r bes'16( a g fis  g4)-. r2 bes16( a g fis  g4)-. |
	r2 c16( bes a g  a4)-. r2  c16( bes a g  a4)-. |
	r2 d16( c bes a  bes4)-. bes16( a g fis  g4)-. g16( f es  d) es( d c  bes) |	c4 bes a g fis-. d'-. r2 |
	bes'8 bes4 bes bes bes8 bes, bes4 bes bes bes8 g' g4 g g g8 |
	<< {d d4 d d d8 | d4} { a8 a4 a a a8 | bes4} >> r4 r2 |
	g,4\p r r2 
	\repeat unfold 4 { g4  r r2 }
	es4 r r2 es'4 r r2 \dim d4 r r2 d4 r r2 \enddim d4\pp r d r d r r2 |
	<< { d2:16\f d: d: d: es: es: es: es: d: d: d: d: es: es: es: es: }
	 { bes2:16 bes: bes: bes: c: c: c: c: bes: bes: bes: bes: c: c: c: c: }
	>>
	\repeat unfold 2 { f32( es  d8.) d8-. d-. d4-. r }
	\repeat unfold 2 { bes32( a  g8.) g8-. g-. g4-. r }
	\repeat unfold 2 { es'32( d  c8.) c8-. c-. c4-. r }
	\repeat unfold 2 { a32( g  f8.) f8-. f-. f4-. r }
	\repeat unfold 2 { d'32( c  bes8.) bes8-. bes-. bes4-. r }
	\repeat unfold 2 { g'32( f  es8.) es8-. es-. es4-. r }
	r1 es'4 c a f r1 bes4 f d bes r1 bes'4 f des bes r1 |
	des'4 bes g e f ges f e f f f, r |
	R1*4
	d'4\p e f d c bes a bes |
	es! a, bes f g8(  es') d-. c-. f\f f4 f8 ~ |
	\repeat unfold 3 { f f4 f f f8 ~ }
	f(  c') bes-. a-. bes4 g | 
	c, d g8(  es) es-. es-. es(  d) c-. bes-. a(  c) c-. c-. |
	c(  bes) d-. f-. f(  es) d-. c-. bes4 r r8 d f d |
	bes4 r r8 g' bes g f4 g g f |
	bes,2 r4 bes16( c d  es) f2 r4 f16( es d  c) bes2 r4 bes16( c d  es) |
	f2 r4 f16( es d  c) bes4 bes( c  d) es( c  a) fis'
    }
    \repeat volta 2 {
        g g,( as  bes) c( as  f!) d'(  es) es,( f  g) as( f  d) b'( |
	 c8) \repeat unfold 15 { es }
	\repeat unfold 16 { fis }
	g g g g bes bes bes bes
	\repeat unfold 8 { g }
	\repeat unfold 16 { e }
	d \repeat unfold 13 { f } d d
	<e cis>4 r r 2 a,4\p r r2 |
	a4 r r2 a4 r r2 a4 a'(\f bes  gis) a-. g!( f  e) d r r2 d4\p r r2 |
	d4 r r2 d4 r r2 d4 d(\f es!  cis) d-. c!( bes  a) | 
	g2 r8 g'-. g(  fis) fis2 r8 f-. f(  e) |
	e2 r8 es-. es(  d) d2 r8 es-. es(  d) d2 r8 c'-. c(  bes)
	a2 r8 c,-. c(  bes) a2 r2 R1 |
	<s \firstUnisonTheme>1\f
	g4 r bes'16( a g fis  g4)-. r2 bes16( a g fis  g4)-. |
	r2 c16( bes a g  a4)-. r2  c16( bes a g  a4)-. |
	r2 d16( c bes a  bes4)-. bes16( a g fis  g4)-. g16( f es  d) es( d c  bes) |	c4 bes a g fis-. d'-. r2 |
	bes'8 bes4 bes bes bes8 bes, bes4 bes bes bes8 g' g4 g g g8 |
	<< {d d4 d d d8 | d4} { a8 a4 a a a8 | bes4} >> r4 r2 |
	g,4\p r r2 
	\repeat unfold 4 { g4  r r2 }
	es4 r r2 es'4 r r2 
	\decresc d4 r r2 d4 r r2 \enddecresc d4\pp r d r d r r2 |
	<< { bes2:16\f bes: bes: bes: c: c: d: d: |
            d: d: bes: bes: c: c: d: d: }
	  { g,:16 g: g: g: a: a: a: a: bes: g: g: g: a: a: a: a: }
	>>
	\repeat unfold 2 { d32( c  bes8.) bes8-. bes-. bes4-. r }
	\repeat unfold 2 { g'32( f  es8.) es8-. es-. es4-. r }
	\repeat unfold 2 { c32( bes  a8.) a8-. a-. a4-. r }
	\repeat unfold 2 { f'32( es  d8.) d8-. d-. d4-. r }
	\repeat unfold 2 { bes32( a  g8.) g8-. g-. g4-. r }
	\repeat unfold 2 { es'32( d  c8.) c8-. c-. c4-. r }
	R1 c'4 a fis d R1 g4 d bes g R1 as'4 f! d b R1
	c'4 g es c R1 bes'4 g e cis d es! d cis d d' d, r |
	R1*4
	bes4\p cis d bes a g fis g c! fis, g8 bes4 g'8 |
	es(  c) bes-. a-. g8\f d'4 d8 ~
	\repeat unfold 3 { d d4 d d d8 ~ }
	d(  a') g-. fis-. g4 e a, bes es!8(  c) c-. c-. |
	c(  bes) a-. g-. fis4 fis'-. g4. d'8 d(  c) bes-. a-. |
	g4 r r8 bes,\f d bes g4 r r8 g' es g g,4 es' es d
	\repeat unfold 2 { g,2 r4 g16( a bes  c) d2 r4 d16( c bes  a) }
	g4 bes( c  d) es( c a  fis') |
    } % repeat
    % Coda
    g r r2 R1 g8 g4 g g g8 d d4 d d d8 es es4 es es es8 b b4 b b b8 |
    c c4 c8 fis, fis4 fis8 g g4 g8 es' es4 es8 es es4 es8 d d4 d8 |
    d4 r r2 g4 g8. g16 g4 g d'2 bes4 g d g bes, d g, r r2
}
cello =  \relative c' {
    \repeat volta 2 {
	g'4\f g g g d d d d es es es es fis, fis fis fis | 
%\set Score.skipTypesetting = ##t
	g r bes16( a g fis  g4)-. r2 bes16( a g fis  g4)-. |
	r2 c16( bes a g  a4)-. r2  c16( bes a g  a4)-. |
	r2 d16( c bes a  bes4)-. bes16( a g fis  g4)-. g'16( f es  d) es( d c  bes) |	c4 bes a g fis-. d'-. r2 |
	r4 g,,-. bes-. d-. r g-. bes-. g-. r c,-. g'-. c-. r a-. d-. c-. |
	bes r r2 g4\p r r2
	\repeat unfold 4 { g,4 r r2 }
	es4 r r2 es'4 r r2 \dim d4 r r2 d4 r r2 \enddim d4\pp r d r d r r2 |
	bes\f r r1
	\repeat unfold 2 {
		f' es' d32( c  bes8.) bes8-. bes-. bes4-. r
		d32( c  bes8.) bes8-. bes-. bes4-. r
	}
	\repeat unfold 2 { g32( f  es8.) es8-. es-. es4-. r }
	\repeat unfold 2 { c'32( bes  a8.) a8-. a-. a4-. r }
	\repeat unfold 2 { f32( es  d8.) d8-. d-. d4-. r }
	\repeat unfold 2 { bes'32( a  g8.) g8-. g-. g4-. r }
	\repeat unfold 2 { es32( d  c8.) c8-. c-. c4-. r }
	r1 es'4 c a f r1 bes4 f d bes r1 bes'4 f des bes r1 |
	des'4 bes g e f ges f e f f f, r |
	d'-.\p bes-. es-. bes-. f'-. bes,-. g'-. es-. |
	d-. bes-. es-. bes-. f'-. bes,-. g'-. es-. |
	d e f d c bes a bes |
	es! a bes d, es f bes\f f a f bes f c' f, d' f, |
	a f bes f c' f, d' e f d c a bes bes, f' fis |
	g d es f! bes, r r8 bes' d bes g4 r r8 es g es d4 g es f |
	bes,2 r4 bes16( c d  es) f2 r4 f16( es d  c) bes2 r4 bes16( c d  es) |
	f2 r4 f16( es d  c) bes4 bes'( c  d) es( c  a) fis'
%\set Score.skipTypesetting = ##f
    }
    \repeat volta 2 {
        g g,( as  bes) c( as  f!) d'(  es) es,( f  g) as( f  d) b'( |
	 c) r c-. g-. es'-. r8 g,-. c4-. es-. c, r8 a'! d4 a |
%\set Score.skipTypesetting = ##t
	fis' r8 a, d4 c
	\repeat unfold 2 { bes r8 d, g4 d }
	bes' r8 bes g4 bes |
	e, r8 e' cis4 a d r8 a f4 d bes r8 bes bes'4 bes, |
	a r r2 a4\p r r2 |
	a4 r r2 a4 r r2 a4 a'(\f bes  gis) a-. g!( f  e) d r r2 d4\p r r2 |
	d4 r r2 d4 r r2 d4 d'(\f es!  cis) d-. c!( bes  a) | 
	g2 r R1*7 |
	g'4\f g g g d d d d es es es es fis, fis fis fis | 
	g r bes16( a g fis  g4)-. r2 bes16( a g fis  g4)-. |
	r2 c16( bes a g  a4)-. r2  c16( bes a g  a4)-. |
	r2 d16( c bes a  bes4)-. bes16( a g fis  g4)-. g'16( f es  d) es( d c  bes) |	c4 bes a g fis-. d'-. r2 |
	r4 g,,-. bes-. d-. r g-. bes-. g-. r c,-. g'-. c-. r a-. d-. c-. |
	bes r r2 g4\p r r2
	\repeat unfold 4 { g,4 r r2 }
	es4 r r2 es'4 r r2 \decresc d4 r r2 d4 r r2 \enddecresc d4\pp r d r d r r2 |
	g,\f r R1
	\repeat unfold 2 { 
	    d'1 c' 
	    \repeat unfold 2 { bes32( a  g8.) g8-. g-. g4-. r }
	}
	\repeat unfold 2 { es'32( d  c8.) c8-. c-. c4-. r }
	\repeat unfold 2 { a32( g  f8.) f8-. f-. f4-. r }
	\repeat unfold 2 { d'32( c  bes8.) bes8-. bes-. bes4-. r }
	\repeat unfold 2 { g32( f  es8.) es8-. es-. es4-. r }
	\repeat unfold 2 { c'32( bes  a8.) a8-. a-. a4-. r }
	R1 c4 a fis d R1 g4 d bes g R1 as'4 f! d b R1
	c'4 g es c R1 bes'4 g e cis d es! d cis d d' d, r |
	bes'\p-. g-. c-. g-. d'-. g,-. es'-. c-. bes-. g,-. c-. g-. |
	d'-. g,-. es'-. c-. bes cis d bes' a g fis g c,! fis, g  es' |
	c d g-.\f d-.
	fis-. d-. g-. d-. a' d, bes' d, fis d g d a' d, bes' cis, |
%\set Score.skipTypesetting = ##f
	d bes a fis' g g, d' d es bes c! d g, r r8 g'\f bes g |
	es4 r r8 es g es d4 es c d
	\repeat unfold 2 { g2 r4 g16( a bes  c) d2 r4 d16( c bes  a) }
	g4 bes( c  d) es( c a  fis') |
    } % repeat
    % coda
    g r r2 R1 g4 g g g d d d d es es es es b8 b4 b b b8 |
    c4 c fis, fis g g es' es c c d d |
    g,4 r r2 g4 g8. g16 g4 g d'2 bes4 g d g bes, d g, r r2
}