\version "2.12.2"

standardNotation = {
  \compressFullBarRests
  %\override MultiMeasureRest #'expand-limit = #11
  #(set-accidental-style 'modern-cautionary)
  \set countPercentRepeats = ##t
}

globalI = {
  \standardNotation
  \time 2/2
  \key d \major
  \tempo "Allegretto."

  \repeat volta 2 {
    \partial 4 s4
    s1*23 \mark \default %A
    s1*16 \mark \default %B
    s1*33 \mark \default %C
    s1*25
    s2. } s4 |
  s1*2 |
  \repeat volta 2 {
    s1*14 \mark \default %D
    s1*19 \mark \default %E
    s1*32 \mark \default %F
    s1*24 \mark \default %G
    s1*30 \mark \default %H
    s1*21
  }
  \alternative { { s1*2 } { s1*2 } }
  s1*6 \mark \default %J (I)
  s1*18 \bar "|."
  
}

globalII = {
  \standardNotation
  \time 3/4
  \key d \major
  \tempo "Allegretto."

  \repeat volta 2 {
    \partial 4 s4 \bar "||"
    \mark \markup { \musicglyph #"scripts.segno" }
    s2.*7 |
    s2 }
  \repeat volta 2 {
    s4 |
    s2.*19 |
    s2 }

}

globalIII = {
  \standardNotation
  \time 3/4
  \key d \minor

  \repeat volta 2 {
    \partial 4 s4 |
    s2.*7 |
    s2 } \bar ""
  \repeat volta 2 {
    s4 |
    s2.*15
  }
   \alternative { { \partial 2 s2 } { s2. | } }
  \override Score.RehearsalMark #'self-alignment-X = #RIGHT 
  s2.*2
  s2. _"M.d.C dal segno."
  \override Score.RehearsalMark #'break-visibility = #begin-of-line-invisible
  \override Score.RehearsalMark #'self-alignment-X = #RIGHT  
  \mark \markup { \musicglyph #"scripts.segno" }
  \bar  "||"

}

globalIV = {
  \standardNotation
  \time 3/4
  \key g \major
  \tempo "Adiago."

  s2.*10 \mark #10 %K
  s2.*18 \mark \default %L
  s2.*11 \mark \default %M
  s2.*14 \mark \default %N
  s2.*14 \mark \default %O
  s2.*14 \mark \default %P
  s2.*14 \mark \default %Q
  s2.*10 \bar "|."

}

globalV = {
  \standardNotation
  \time 2/4
  \key d \major
  \tempo "Allegro."

  \repeat volta 2 {
    s2*20 \mark #17 %R
    s2*43 \mark \default %S
    s2*33 \mark \default %T
    s2*34 \mark \default %U
    s2*25
  }
  \repeat volta 2 {
    s2*6 |
    R2 -\markup \large \italic "G.P."
    s2*18 \mark \default %V
    s2*37 \mark \default %W
    s2*57 \mark \default %X
    s2*40 \mark \default %Y
    s2*19 |
  }
  s2*3 |
  R2 -\markup \large \italic "G.P."
  s2*3 |
  R2 -\markup \large \italic "G.P."
  s2*9 \mark \default %Z
  s2*33
  \override Score.RehearsalMark #'break-visibility = #begin-of-line-invisible
  \override Score.RehearsalMark #'self-alignment-X = #RIGHT 
  \mark \markup { \musicglyph #"scripts.ufermata" }
  \bar "|."

}

ViolinOneI = \new Voice { \relative c''{
  \set Staff.instrumentName = #"Violin 1 "
  \clef treble

  fis4(-3\downbow \p |
  d8)-. r d4(-3 fis,8)-. r fis4( |
  a2.) fis8.( d16) |
  a4 a(-. a-. a)-. |
  a2. g'8.( e16) |

  cis4 cis(-. cis-. cis)-. |
  cis2.-1 b'8.( g16) |
  e4 e-.( -\markup \teeny "III" e-. e-.) |
  e2. e'8.( cis16) |

  g4 g-.(-2 g-. g)-. |
  fis(\> b)\! r cis,( |
  d-1 g fis-4 e) |
  e2( fis4) d''( |

  fis,8)-.-1 r fis4( b8)-. r b4( |
  e, a2) g8.( e16) \open |
  d4 d-1 d e8.( fis16) d4 r r2 |
  R1*3 |

  \dimTextDecresc r4 d8(\> e fis g e fis) |
  d4\! r r2 |
  r4 e8.(\pp fis16) d4 r |
  r fis(\f -"I" gis ais) |

  %%% A

  b2-2 fis |
  d4.(\trill cis16-2 d) b2~ |
  b4 ais(\p g'-4 fis) |
  e2( d4) r |

  d2-3\f \acciaccatura cis8 d4-.( \acciaccatura cis8 d4-.) |
  e8( d cis b) b2~ |
  b8\p cis( d dis e4 d) |
  \dimHairpin bis\> cis r\! e\f\upbow |

  fis4.( gis8 a gis a fis) |
  e4( cis) r e\upbow |
  fis8( gis a fis a gis a fis) |
  e4( cis) r8 e(\p\downbow d cis) |

  b-.( b-. b4--) r8 e(\f d cis) |
  b-. b-. b4 r8 e(\downbow\p d c) |
  \crescTextCresc b4-.(\< b-. b-. b-.) |
  b2.\(\f \acciaccatura d8 cis b\) |

  %%% B

  b4 r r b'4(\p |
  gis8-.) r gis4( b,8-.) r b4( |
  e) r r b'(\downbow |
  gis8-.) r gis4( b,8-.) r b4( |

  e2.) d8.(\downbow b16) |
  gis8 r gis4( b8-.-1) r b4\( |
  e,2.-1 \acciaccatura gis8 fis e\) |
  e4 e d d |

  cis4 r r \times 2/3 { e8 fis gis } |
  a4-4 a b b |
  \times 2/3 { cis8 d cis } \times 2/3 { a8[ b cis] } \times 2/3 { d8[ e d] } \times 2/3 { b8[ cis d] } |
  e4 r fis r |
  gis(\f a) r a,(\p\downbow |

  d1~ |
  d1~ |
  d4 e d8 cis b a) |
  \afterGrace b1(\trill { a16[ b] } |
  a4) r r2 |

  cis1-4 -\markup \italic "(espressivo)" |
  a2( fis) |
  cis2.\( \acciaccatura e8 d cis\) |
  cis2. cis''4(\p |
  
  a8) r a4-3( cis,8) r cis4( |
  e2.) cis8.(\> a16) |
  e4\p e e( gis) |
  a4 r r2 |

  r2 r4 c'16-3(\p\upbow bes8.) |
  a2. gis16-1(\downbow a8.) |
  bes2. a16(\upbow bes8.) |
  a2. c4( |

  \crescHairpin a8)\< r a4-3(\upbow c,8) r c4(\downbow |
  e2.)\> cis8.( a16) |
  e4\p e e( gis) |

  %%% C

  \set crescendoText = \markup { \italic { cresc. poco a poco } }
  \set crescendoSpanner = #'text

  a \appoggiatura b16-3\< a8( gis16 a) fis4-1( b8) r |
  r4 \appoggiatura d16-\markup \teeny "II" cis8( b16 cis) a4( d8) r |
  r4 \appoggiatura fis16-3 e8( d16 e) cis4-1( fis) |
  b,-1( e a,) d~ |
  d(\f cis) cis8( b) b-3( gis) |

  a4 r r \appoggiatura e'16-\markup \teeny "II" d8(\p cis16 d) |
  b4( e8) r r4 \appoggiatura g?16-4\< fis8( e16 fis) |
  d4( gis~ gis) \appoggiatura b16 -\markup \teeny "I" a8( gis16 a) |
  gis4 \appoggiatura a16 g8( fis16 g) fis4 \appoggiatura g16-4 f8( e16 f) |
  e2~(\f e8 d cis-2 b) |

  \crescTextCresc
  \override TextScript #'script-priority = #-100
  \override TextScript #'avoid-slur = #'outside

  a4 cis'16-3(\p\upbow e,8.-2) e2~\< |
  e4 cis'16(\downbow e,8.) e4-.( e-.) |
  fis4\f d'16(\upbow fis,8.) fis2~ |
  fis8(\p e) e-. e-. e4( ^\markup { \sharp } ^\turn fis8 gis) |

  a4 cis16(\<\upbow e,8.) e2~ |
  e4 cis'16(\downbow e,8.) e4-.( e4-.) |
  fis\f d'16( fis,8.) fis2~ |
  fis8(\p e) e-. e-. e4( ^\markup { \sharp } ^\turn fis8 gis) |

  a4\f d16( fis,8.) fis2~ |
  fis8(\p e) e-. e-. e4( ^\markup { \sharp } ^\turn fis8 gis8) |
  a4\f d16( fis,8.) fis2~ |
  fis8(\p e) e-. e-. e4( ^\markup { \sharp } ^\turn fis8 gis8) |

  a-0( e) e-.( e-.) e4( ^\markup { \sharp } ^\turn fis8 gis) |
  a-0( e) e-.( e-.) e4( ^\markup { \sharp } ^\turn fis8 gis) |
  a-.\pp cis-.\upbow b-. cis-. a-. cis-. b-. cis-. |
  a4 r r

  \override TextScript #'script-priority = #450
  \override TextScript #'avoid-slur = #'around

  %% Interlude

  r |
  a8-. c-. b-. c-. a-. c-. b-. c-. |
  a4 r r2 |

  %% 2nd big repeat

  c4\f c c c |
  c1~-1 |
  c~ |
  c~ |

  c8 g'-.-4\upbow f-.-3 g-. e-. g-. f-. g-. |
  e-. g-. f-. g-. e-. g-. f-. e-. |
  f-. c-.-3 bes-. c-. a-. c-. bes-. c-. |
  a-. c-. bes-. c-. a-. c-. bes-. a-. |

  bes-. bes-.-4 a-. bes-. g-. bes-. a-. bes-. |
  a-. bes-. a-. bes-. g-. bes-. a-. g-. |
  a-. a-. g-. a-. f-. a-. g-. a-. |
  f-. a-. g-. a-. f-. a-. g-. f-. |

  g4 r r2 |

  %% D?

  r r4 f'(\downbow\p |
  d8) r d4( f,8) r f4( |
  a2.) f8.-3(\downbow d16) |
  a4 a a a |
  a2.

 }}

ViolinOneII = \new Voice { \relative c''{
  \set Staff.instrumentName = #"Violin 1 "
  \clef treble

 }}

ViolinOneIII = \new Voice { \relative c''{
  \set Staff.instrumentName = #"Violin 1 "
  \clef treble

 }}

ViolinOneIV = \new Voice { \relative c''{
  \set Staff.instrumentName = #"Violin 1 "
  \clef treble

 }}

ViolinOneV = \new Voice { \relative c''{
  \set Staff.instrumentName = #"Violin 1 "
  \clef treble

 }}

%*********************************

ViolinTwoI = \new Voice { \relative c'' {
  \set Staff.instrumentName = #"Violin 2 "
  \clef treble

  fis4-3( \downbow \p 
  d8-.) r d4-3( fis,8)-. r fis4( |
  a2. fis8.( d16) |
  a4 a-.( a-. a-.) |

  a1~ a~ a2. g'8.(-0 e16) |
  cis4 cis-.( cis-. cis)-. |
  cis2. cis'8.( g16) |
  e4 e(-. e-. e-.) |

  d2 r4 a~ |
  a d~( d cis) |
  cis2( d4) r |

  r d'8.( \downbow b16) g4-. g8.( e16) |
  cis4-. fis8.( d16) b4-. b'8.( g16) |
  fis4-. b8.( gis16) a4-. a,-. |
  d-. fis8.( a16) d4-. \open r |
  R1*3 |

  \dimTextDecresc r4 b( \downbow\> a) a,-.( |
  d-.)\! r r2 |
  r4 a'(\pp fis) r |
  r a(\f\upbow b e) |

  %%% A

  d2 cis |
  b r4 fis(\p |
  g2) r4 cis-4 |
  cis2( b4) r |

  gis1~(\f |
  gis8 b a gis) gis2~ |
  gis8\p a( b bis cis4 b) |
  gis( a) r e\upbow\f |

  fis4.( gis8 a gis a fis) |
  e4( cis) r e\upbow |
  fis8( gis a gis a gis a fis) |
  e4( cis) r8 cis'-4(\p\downbow b a) |

  gis-.( gis-. gis4--) r8 cis(\f b a) |
  gis-. gis-. gis4 r8 c(\p\downbow b a) |
  \crescTextCresc gis4-.(\< gis-. gis-. gis-.) |
  a1\f |

  %%% B

  \dimHairpin gis8-3( e gis e) b(\p e gis e |
  b e gis e) dis( fis a fis) |
  e( gis b gis) dis( fis a fis) |
  b,( e gis e dis fis a fis) |

  e( gis b gis e gis b gis) |
  d?( e gis e d e gis e) |
  b( d e d gis, b d b) |
  gis( b d b gis b d b) |

  a( cis e cis b e gis e) |
  cis( e a e d e gis e) |
  \crescTextCresc cis(\< e a e) d( e gis e) |
  e( a cis a) fis( a d a) |
  d4(\f cis) r2 |

  R1 |
  r4 d,(\p\upbow bes'-3 a) |
  gis2( a~ |
  a gis) |

  a8( fis cis b a cis fis cis) |
  b( cis gis' cis, b cis eis cis) |
  fis( cis a cis a cis fis cis) |
  gis( b cis b gis b gis b) |

  a( cis fis cis a cis fis cis) |
  \crescHairpin \dimHairpin fis(\< cis a cis a cis fis cis) |
  a(\> cis e? cis a cis e cis) |
  gis(\p b d b d b e d) |

  c( f a f) a,( c f c) |
  bes( c g' c,) gis( c e c) |
  a( c f c a c f c) |
  gis( c gis' c, gis e' gis e) |

  f( a f c a c f c) |
  dis-4(\< c dis c a c dis c) |
  a(\> cis e cis a cis e cis) |
  gis(\p b d b d b e d) |

  %%% C

  \set crescendoText = \markup { \italic { cresc. poco a poco } }
  \set crescendoSpanner = #'text
  %\override DynamicTextSpanner #'style = #'dotted-line

  cis4 r r fis(\< \noBreak |
  a gis) r a-2( |
  b2 a4) \appoggiatura b16 a8( gis16 a) |
  gis4 \appoggiatura a16-4 g?8( fis16 g) fis4 \appoggiatura g16 f8( a16 f) |

  e2~(\f e8 d-0) d-4( b) |
  cis4 r r \appoggiatura cis'16-4\downbow b8(\p a16 b) |
  gis4( cis8) r r4 \appoggiatura e16 -\markup \teeny "II" d8(\< cis16 d) |

  b4( e~ e) dis( |
  d cis c) b~ |
  b(\f cis~) cis8( b a gis) |

  \crescTextCresc a\p a a a a\< a a a |
  a a a a a a a a |
  a\f a a a a a( d cis) |
  b\p b b b b b( cis d) |

  cis a\< a a a a a a |
  a a a a a a a a |
  a\f a a a a a( d cis) |
  b\p b b b b b( cis d) |

  cis8\f( fis4 e8) d( cis b a) |
  gis\p gis a a b( d cis b |
  a\f fis'4( e8 d cis b a) |
  ais\p gis a a b( d cis b) |

  a(\upbow \noBeam cis,) cis-. cis-. cis cis cis cis |
  cis cis cis cis d d d d |
  cis \noBeam e'-.\pp d-. e-. cis-. e-. d-. e-. cis4 r r 

  %%% Interlude
  r |
  c8-. e-. d-. e-. c-. e-. d-. e-. |
  c4 r r2 |

  %%% 2nd Big Repeat

  e8-.\f g-. f-. g-. e-. g-.f-. g-. |
  e-. g-. f-. g-. e-. g-. f-. e-. |
  f-. a-. g-. a-. f-. a-. g-. a-. |
  f-. a-. g-. a-. f-. a-. g-. f-. |

  g-. bes-. a-. bes-. g-. bes-. a-. bes-. |
  g-. bes-. a-. bes-. g-. bes-. a-. g-. |
  a-. a-. g-. a-. f-. a-. g-. a-. |
  f-. a-. g-. a-. f-. a-. g-. f-. |

  g4-. r r2 |
  r2 r4 f4-3(\downbow\f |
  d8-.) r d4-.( f,8-.) r f4( |
  a2.) f8.(\downbow d16) |

  a4 a a a |
  a1~ |

  %%% D

  a8\p \noBeam f'-.\upbow e-. f-. a-. f-. e-. f-. |
  d-. f-. e-. f-. e-. f-. e-. d-.-0 |
  ees-.-3 ees-. d-. ees-. a-. ees-. d-. ees-. |
  a-. ees-. d-. ees-. c-. ees-. d-. c-. |

  d-.-0  f-. ees-. f-. d-. f-. ees-. f-. |
  d-. f-. ees-. f-. d-. f-. ees-. d-. |
  c-.-1 ees-. d-. ees-. c-. ees-. d-. ees-. |
  c-. \noBeam c'-. bes-. c-. a-. c-. bes-. a-. |

  bes-. bes-. a-. bes-. g-. bes-. a-. bes-. |
  g-. d-.-0 c-. d-. bes-. d-. c-. bes-. |
  aes-. \noBeam f'-. ees-. f-. d-. aes'-.-3 g-. aes-. |
  f-. aes-. g-. aes-. f-. aes-. g-. f-. |

  g-.\< bes-. aes-. bes-. a-. bes-. aes-. g-. |
  f-.\f \noBeam f'-. ees-. f-. a-. f-. ees-. f-. |
  ees-.-2 g-. f-. g-. ees-. g-. f-. ees-. |

  d2-0( -\markup \italic "calando" gis,-1) |
  f-4( d) |
  gis,1~\p |
  gis |

  %%% E

  a8 \downbow cis-. b-. cis-. a-. cis-. b-. cis-. |
  a-. e'-.-3 d-. e-. cis-. e-. d-. e-. |
  cis-. g'-.-3 fis-. g-. e-. g-. fis-. g-. |
  e-. \noBeam e'-. d-. e-. cis-. g'-.-4 fis-. g-. |

  e-. \< r e4-1( g8) r g4( |
  cis8) r cis4( e8) r e4( -\markup \italic "calando" |
  cis8) r cis4( g8) r g4( |
  e8) r e4( fis8) r fis4-3( \p \downbow |

  d8) r d4-3( fis,8) r fis4( |
  a2.) fis8.( d16) |
  a4 a-.( a-. a-.) |
  a1~ a a2. g'8.-0( e16) |

  cis4 cis-.( cis-. cis-.) |
  cis2. cis'8.( g16) |
  e4 e-.( e-. e-.) |
  d2 r4 a~ |

  a d~( d cis) |
  cis2( d4) r |
  r d'8.( \downbow b16) g4-.

}}

ViolinTwoII = \new Voice { \relative c'' {
  \set Staff.instrumentName = #"Violin 2 "
  \clef treble

 }}

ViolinTwoIII = \new Voice { \relative c'' {
  \set Staff.instrumentName = #"Violin 2 "
  \clef treble

 }}

ViolinTwoIV = \new Voice { \relative c'' {
  \set Staff.instrumentName = #"Violin 2 "
  \clef treble

 }}

ViolinTwoV = \new Voice { \relative c'' {
  \set Staff.instrumentName = #"Violin 2 "
  \clef treble

 }}

%*********************************

ViolaI = \new Voice { \relative c' {
  \set Staff.instrumentName = #"Viola "
  \clef alto

  fis4( \p \downbow |
  d8)-. r d4-4( fis,8-.) r fis4-1( |
  a2. fis8.-3( d16) |
  a'4 a-.( a-. a-.) |
  a2. cis,8.( e16) |

  g4 g-.( g-. g-.) |
  g2. cis,8.( e16) |
  g4 g-.( g-. g-.) |
  g2. e8.( g16) |

  cis4 cis-.( cis-. cis-.) |
  d( b) r e,(\( |
  fis g a) <g a>-.\) |
  \set doubleSlurs = ##t <g a>2( <fis a>4) \set doubleSlurs = ##f r |

  R1*3 |

  r2 r4 d''4( \p \upbow |
  fis,8) r fis4( b8)-.-3 r b4( |
  e,-1 a~ a) g8.( e16) |
  d4 d d e8.( fis16) |
  d4-. r r2 |

  r4 \dimTextDecresc d8(\> e fis g e fis) |
  d4\! r r e8.(\pp fis16) |
  d4 fis(\f e fis) |

  %%% A

  fis2 fis |
  fis r4 d(\p |
  e2) r4 fis~(-1 |
  fis ais b) r |

  b,1~ -1 \f |
  b4 e,(\( e') e-.\) |
  e1~\p |
  e2. cis4\f |

  d4.-2( e8 fis e fis d) |
  cis4-3( a) r cis-1\upbow |
  d8( e fis e fis f fis d) |
  cis4-3( a) e'2~\p |

  e8 e-.( e-. e-.) e2~\f |
  e8 e-.( e-. e-.) e2(\p |
  \crescTextCresc f4)\< f-.( f-. f-.) |
  fis?1\f |

  %%% B
  b,4 r r2 |
  r4 e(\p fis8) r dis4( |
  b') r r2 |

  r4 e,(\upbow fis8) r dis4( |
  b'2-3 gis) |
  b,( gis)\< |

  \repeat unfold 5 e1~ |
  e4 e'4~\downbow\( e d8( fis)\) |
  b4(\f a) r2 |
  r4 a,4(\p\downbow fis'2-4) |

  f1 |
  e2( a,4-1 e') |
  fis?2( e4 d) |
  cis r r2 |

  R1*3 |
  r2 r4 cis'4-4(\p\downbow |

  \crescHairpin \dimHairpin a8)\< r a4( cis,8) r cis4( |
  e2.)\> cis8.-3(\downbow a16) |
  e4\p e e-1( gis) |
  a d'16-3(\upbow c8.) c2~ |

  c4 b16(\downbow c8.) c2~ |
  c4 d16(\upbow c8.) c2~ |
  c4 b16( c8.) c2~ |
  c4 d16( c8.) c4 c( |

  a8)\< r a4(\upbow c,8) r c4-1( |
  e2.)\> cis8.-3(\downbow a16) |
  e4\p e e-1( gis) |

  %%% C

  \set crescendoText = \markup { \italic { cresc. poco a poco } }
  \set crescendoSpanner = #'text
  a r r b(\<\downbow |
  fis'-4 e) r d( |
  f e~ e) c-3( |
  b bes a gis8 a) |
  b4(\f a) fis'?( e) |

  e \appoggiatura d16 cis8(\p b16 cis) a4( d8) r |
  r4 \appoggiatura fis16-4 e8(\< d16 e) cis4( e8) r |
  r4 \appoggiatura a16-4 gis8( fis16 gis) e4 c'( |

  b bes a gis~ |
  gis)\f a( fis e) |

  \crescTextCresc <cis e>8\p <cis e> <cis e> <cis e> <cis e>\< <cis e> <cis e> <cis e> |
  <cis e> <cis e> <cis e> <cis e> <cis e> <cis e> <cis e> <cis e> |
  <b fis'>\f <b fis'> <b fis'> <b fis'> <b fis'> <b fis'> a' a |
  a-2\p a gis gis gis gis( a b) |

  a <cis, e> <cis e> <cis e> <cis e>\< <cis e> <cis e> <cis e>  |
  <cis e> <cis e> <cis e> <cis e> <cis e> <cis e> <cis e> <cis e> |
  <b fis'>\f <b fis'> <b fis'> <b fis'> <b fis'> <b fis'> a' a |
  a-2\p a gis gis gis gis( a b) |

  a4.(\f gis8 fis-2 e d-4 cis) |
  b-.(\p b-. cis-. cis-.) d( fis e d |
  cis)\f a'4( gis8 fis e d cis) |
  b\p b cis cis d( fis e d) |

  cis( a) a-. a-. b b b b |
  a a a a b b b b |
  a-.\pp r gis'-. r a-. r gis-. r |
  a4 r r 

  %% Interlude

  r |
  e8-. r gis-. r a-. r gis-. r |
  a4 r r2 |

  %%% 2nd Big repeat section

  g?8-.-1\f bes-. a-. bes-. g-. bes-. a-. bes-. |
  g-. bes-. a-. bes-. g-. bes-. a-. g-. |
  a-. c-. bes-. c-. a-. c-. bes-. c-. |
  a-. c-. bes-. c-. a-. c-. bes-. a-. |

  bes4-. r r2 |
  r2 r4 a4-4(\f\downbow |
  f8) r f4( a,8) r a4( |
  c2.) a8.(\downbow f16) |

  cis4 cis cis cis |
  cis2( a'-3) |
  d,4 r r2 |

  R1 |
  r8 g'-.\f f-. g-. e-. g-. f-. g-. |
  e-. g-. f-. g-. e-. g-.-1 f-.-4 e-. |

  %%% D

  f \noBeam a,-.\p g-. a-. f-. a-. g-. a-. |
  f-. a-. g-. a-. g-. a-. g-. f-. |
  c'-.-3 c-. bes-. c-. a-. c-. bes-. c-. |
  a-. c-. bes-. c-. a-. c-. bes-. a-. |

  bes-. d-. c-. d-. bes-. d-. c-. d-. |
  bes-. d-. c-. d-. bes-. a-. c-. bes-. |
  a-. c-. bes-. c-. a-. c-. bes-. c-. |
  a-. \noBeam ees'-.-3 d-. ees-. c-. \noBeam a'-. a-. fis?-.-2 |

  g-. \noBeam d-. c-. d-. bes-. d-. c-. d-. |
  bes-. bes-. a-. bes-. g-. bes-. a-. g-. |
  f-.-1 aes-. f-. aes-. f-. \noBeam f'-. ees-. f-. |
  d-.-0 f-. ees-. f-. d-. f-. ees-. d-. |

  ees-.\< g-. f-. g-. ees-. g-. f-. ees-. |
  d-.\f\noBeam aes'-. g-. aes-. f-. aes-. g-. f-. |
  g-.-1 bes-. aes-. bes-. g-. bes-. aes-. g-. |

  aes2( -\markup \italic "calando" f) |
  d( aes) |
  f1~-3\p |
  f4 d( cis? d) |

  %%% E

  e? r r2 |
  R1 |
  r2 r4 a4(\downbow cis8) r cis4-1( e8) r e4-1( |

  a8 gis a\< gis a gis a gis |
  a gis a gis a gis a gis |
  a)\! r \clef treble g'?4-4( -\markup \italic "calando" e8) r e4-4( |
  cis8) r cis4( d8) r \clef alto fis,4(\p\downbow |

  d8) r d4( fis,8) r fis4( |
  a2.)

}}

ViolaII = \new Voice { \relative c' {
  \set Staff.instrumentName = #"Viola "
  \clef alto

 }}

ViolaIII = \new Voice { \relative c' {
  \set Staff.instrumentName = #"Viola "
  \clef alto

 }}

ViolaIV = \new Voice { \relative c' {
  \set Staff.instrumentName = #"Viola "
  \clef alto

 }}

ViolaV = \new Voice { \relative c' {
  \set Staff.instrumentName = #"Viola "
  \clef alto

 }}

%*********************************

CelloI = \new Voice { \relative c' {
  \set Staff.instrumentName = #"'Cello "
  \clef bass

  fis4-4( \p \downbow |
  d8-.) r d4-2( fis,8-.) r fis4( |
  a2.) fis8.-3( d16) |
  a4 a-.( a-. a-.) |
  a1~ a1~ |

  a4 e'8.-4( cis16) a2~ |
  a1~ |
  a4 e'8.( cis16) a2~ |
  a4 a-1( ais) ais( |

  b g) r g-2( |
  fis b-4 a?) a-. |
  d( a d,) r |
  R1*4 |

  r4 d''8.( \open \downbow \p  b16-4) g4-. g8.( e16-4) |
  cis4-.-1 fis8.-3( d16) b4-. b'8.-4( g16) |
  fis4-.-1 b8.-4( gis16) a4-. a,-. |
  d-. r r2 |

  \dimTextDecresc r4 b'(\> a) a, |
  d\! r r a'-4\pp |
  fis d~(\f d cis) |

  %%% A

  b2 ais |
  b r4 d'(\p -"II" |
  cis2) r4 ais( |
  b) b,~(\sf b cis8-1 d) |

  e4-.\f gis-. b-. gis-. |
  e-. r r2 |
  R1 |
  r4 a,(\f a') a-. |

  a1~ |
  a4 a,( a') a-. |
  a1~ |
  a4 a, r8 a'-1(\p\downbow b cis) |

  d-.( d-. d4--) r8 a-0(\f b cis) |
  d-. d-. d4 r8 a-1(\downbow\p b c) |
  \crescTextCresc d4-.(\< d-. d-. d-.) |
  dis2\f dis,( |

  %%% B

  e4) r r2 |
  r2 r4 b'4-4(\p\downbow |
  gis8-.) r gis4-4( b,8-.) r b4( |
  e-4) r r b'( |

  gis8-.) r gis4( b,8-.) r b4( |
  e2.) d8.(\downbow b16-4) |
  gis8-.r gis4( b8-.) r b4-4\( -\markup \teeny "IV" |
  e,2. \acciaccatura gis8 fis e\) |

  e4 e d d |
  cis r r \times 2/3 { e8-1( fis gis) } |
  a4\< a b b-1 |
  \times 2/3 { cis8[ d cis] } \times 2/3 { a8-.-1[ b-. cis-.-1] } \times 2/3 { d8( [e d)] } \times 2/3 { b8-.-1 [cis-. d-.-0] } |

  e4(\f fis) r2 |
  r2 r4 a,4(\p -\markup \teeny "III" |
  d2.-4) b4 |
  e-4( cis fis-4 cis-3) |
  \crescHairpin \dimHairpin d( b e-4\> e,-1) |

  fis2\! r4 fis(\downbow -\markup \italic "(dolce espressivo)" |
  eis2) r4 cis( |
  fis2) r8 fis(\upbow a fis) |
  eis2 r8 cis(\downbow eis cis) |

  fis1~ |
  fis\< |
  e?~\sf\> |
  e\p |

  f2 r4 f( |
  e2) r4 c( |
  f2) r8 f-1( a f-4) |
  e2 r8 c(\downbow e c) |

  f1~ |
  f\< |
  e~\sf\> |
  e\p |

  %%% C

  \set crescendoText = \markup { \italic { cresc. poco a poco } }
  \set crescendoSpanner = #'text
  a4 r r d(\< |
  dis e) r fis?( |
  g gis a) dis,-3( |
  e cis d b-4) |

  gis(\f a) d( e) |
  a, \appoggiatura b'16-4\downbow a8\p( gis16 a) fis4-1( b8-3) r |
  \clef tenor r4 \appoggiatura d16\< cis8( b16 cis) a4( d8-1) r |

  r4 \appoggiatura fis16 e8( d16 e) cis4( f) |
  b,( e a,) d~ |
  d\f cis-1( d e) |

  \crescTextCresc \clef bass a,2.-4\p cis,16-1(\upbow\< e8.) |
  a2. a,16( cis8.) |
  d2.\f b'16( d8.) |
  e2\p e, |

  a2.-2 cis,16(\< e8.) |
  a2. a,16( cis8.) |
  d2.\f b'16( d8.) |
  e2\p e, |

  fis4\f b,~(\sf\downbow b cis8 d) |
  e2\p e, |
  fis4\f b~(\sf b cis8 d) |
  e2\p e,\upbow |

  a4-. cis-. e-. e,-. |
  a-. cis-. e-. e,-. |
  a8-.\pp r e'-. r a-. r e-. r |
  a,4 r r

  %% Interlude

  r |
  a8-. r e'-. r a-. r e-. r |
  a,4 r r2 |

  %% 2nd repeat section

  R1 |
  r2 r4 a'-4(\f\downbow |
  f8-.-1) r f4-4( a,8-.-3) r a4( |
  c2.-0-3) a8.-4( f16) |

  c4 c c c |
  c1~ |
  c4 r r2 |
  R1 |

  r8 \clef tenor g'''-.\f\upbow f-. g-. e-. g-. f-. g-. |
  e-. g-. f-. g-. e-. g-. f-. e-. |
  f-. f-.-4 e-. f-. d-. f-. e-. f-. |
  d-. f-. e-. f-. d-. f-. e-. d-. |

  e-. e-.-4 d-. e-. cis?-. e-. d-. e-. |
  cis-. e-. d-. e-. cis-. e-. d-. cis-. |

  %%% D

  d4 r r2 \clef bass |
  r r4 a,(\p\downbow |
  f8-.) r f4-1( a8-.) r a4-3( |
  c2.-0) f8.-4( ees16 |

  d4) r r2 |
  r r4 bes-1( |
  d8-.) r d4( fis?8-.-1) r fis4( |
  a2.) d8.-0( c16-4 |

  bes4) r r2 |
  r r4 g,( |
  bes8-.) r bes4-1( d8-.) r d4( |
  f2.) d8.-4( bes16) |

  \crescHairpin g'2.-2\< -\markup \teeny "II" ees8.-2(\f -\markup \teeny "III" bes16) \crescTextCresc
  aes'2. f8.( bes,16) |
  bes'2.-2 g8.-4( ees16) |

  bes1~ -\markup \italic "calando" |
  bes~ |
  bes4\p f'8.( d16) bes4 f'8.( d16) |
  bes1( |

  %%% E

  a4) r r a(\downbow |
  cis?8-4) r cis4-1( e8) e e4-1( |
  a2-4) r |
  R1*3 |

  \clef tenor
  \set decrescendoText = \markup { \italic { calando } }
  \set decrescendoSpanner = #'text

  a'8(\upbow \> gis a gis a gis a gis) |
  a( gis a gis a g-2 fis-4 e |
  d8) \p r \clef bass d4-0( fis,8-.-1) r fis4( |

  a2.) fis8.( d16) |
  a4 a-.( a-. a-.) |

  a4 e'8.( cis16) a2~ |
  a1~ |
  a4 e'8.( cis16) a2~ |
  a1~ |
  a4 e'8.( cis16) a2~ |

  a4 a( ais) ais( |
  b g) r g( |
  fis b a?) a-. |
  d( a d,) r |

  R1*9 |

  r4 e'(\p d) d,-. |
  g-. r r2 |
  r4 d'\pp b b'\ff |

  %%% F

  g2 dis |
  e r4 g(\p |
  fis2) r4 dis( |
  e e,~(\sf e fis8 g) |

  a4-.\f cis-. e-. cis-. |
  a-. r r2 |
  R1 |
  r4 d(\f d') d |

  d1~ |
  d4 d,( d') d |
  d1~ |
  d4 d, r8 d(\p e fis) |

  g-. g-. g4 r8 \clef tenor d'(\f e fis) |
  g-. g-. g4 r8 \clef bass d,(\p e f) |
  g4\< g g g |
  gis2\f gis,( |
  a4) r r2 |

  r r4 e'-4(\p |
  cis8-.) r cis4-4( e,8-.) r e4( |
  a-4) r r e''( |
  cis8-.) r cis4-3( e,8-.) r e4( |

  a2.-2)  g8.(\downbow e16) |
  cis8-. r cis4( e8-.) r e4( |
  a,2.)\( \acciaccatura cis8 b8 a\) |

  %%% G

  a4 a g g |
  fis r r \times 2/3 { a8 b cis } |
  d4\< d e e |
  \times 2/3 { fis8[( g fis)] } \times 2/3 { d8-.[ e-. fis-.-1] } \times 2/3 { g([ a g)] } \times 2/3 { e8-.[ fis-. g-.] } |

  a4(\f b) r2 |
  R1 |
  r4 bes,(\p g' e) |
  a-4( fis b-4 fis) |

  g( e a-4 a,) |
  b?2 r4 b4(\downbow |
  ais2) r4 fis-4( |
  b2-4) r8 b-1(\upbow d b) |
  ais2 r8 fis-1(\downbow ais-4 fis) |

  b1~-4 |
  \crescHairpin  \dimHairpin b \< |
  a?~\sf\> |
  a\p |

  bes2 r4 bes(\downbow |
  a2) r4 f( |
  bes2-4) r8 bes-1(\upbow d bes) |
  a2 r8 f-1(\downbow a f) |

  bes1~-4 |
  bes \< |
  a \sf \> |
  a \p |

  \set crescendoText = \markup { \italic { cresc. poco a poco } }
  \set crescendoSpanner = #'text

  d4 r r g-1(\downbow \< |
  gis a) r b-1( |
  bis cis d) gis,-3( |
  a fis-3 g e) |

  cis-3( \f d) g( a) |

  %%% H

  d, \appoggiatura e16 d8(\p cis16 d) b4( e8) r |
  r4  \appoggiatura g16\< fis8( e16 fis) d4( g8-1) r |
  r4 \appoggiatura b16 a8( g16 a) fis4 b-4( |
  bes a aes) g~-2 |
  g \f fis( g a) |

  \crescTextCresc
  d,2. \p fis16-1(\< a8.) |
  d2. d,,16( fis8.) |
  g2. \f e'16( g8.) |
  a2-1 \p a,-3 |

  d2. \p fis16(\< a8.) |
  d2. d,,16( fis8.) |
  g2. \f e'16( g8.) |
  a2 \p a, |

  b4 \f e~( \sf e fis8-1 g) |
  a2 \p a, |
  b4 \f e,~(\sf e fis8 g) |
  a1 \p |

  d4-. fis-.-1 a-. a,-. |
  d-. fis-. a-. a,-. |
  d8-.-0 \pp r a'-.-1 r d-. r a-. r |
  d,4 r r2 |

  %% 1st Ending
  d'8-. r a-. r d-. r a-. r |
  d4 r r2 |

  %% 2nd Ending
  b,8-. r fis'-. r b-. r fis-. r |
  d,4 r r2 |

  g'8-.-0 r d'-.-0 r g-. r d-. r |
  g,4 r r2 |

  R1*4 |

  %%% I

  gis8-. b-. gis-. b-. gis-. b-. gis-. b-. |
  gis-. b-. gis-. b-. gis-. b-. gis-. b-. |
  a1 |
  a, |

  d4 r r2 |
  R1*3 |

  d,8( \p cis d cis d cis d cis) |
  d( cis d cis d cis d cis) |
  d1~\< |
  d~ \f |

  d4 r r a'( \p |
  d,) r r a''( |
  d,) r r2 |
  R1 |

  r4 a'8-.-1 \pp r d-.-0 r a-. r |
  d4 r r2 ||

}}

CelloII = \new Voice { \relative c, {
  \set Staff.instrumentName = #"'Cello "
  \clef bass

  r4 d \f d' d |
  d d d d d d |
  d d, d |
  d d' d |
  d2 fis4 |
  g e a |
  d, d'

  r4 b, d fis b b, r |
  gis b e, a a' r |
  R2.*2 |
  cis,4 \f d e |
  a,2 a8( \p gis b a) a4-. a8( gis bes a) a4-. a8( gis b a) a4-. a-. a r r |
  d, \f d' d |
  d d d d d d |
  d d, d d d' d |
  d2 fis4 g e a |
  d, \fermata d'

}}

CelloIII = \new Voice { \relative c {
  \set Staff.instrumentName = #"'Cello "
  \clef bass

  \crescTextCresc
  r4 |
  R2.*3 |
  r4 r cis( \sf d) \p r e( f) r bes( a) r a,( d,-.) d'-.

  fis( \sf | g) \p r d( \sf g,) \p r g'( \sf a)\p r c,( \sf |
  g) \p \times 2/3 { f'8-. g-. a-. } bes4 |
  e,~ \times 2/3 { e8 f-. g-. } a4 |

  d,4.( \< e8-.) fis4 |
  g4.( \f a8-.) bes4 |
  a4.( b8-.) cis4 |
  d-. \p d-. e8.( \trill d32 e) |

  f4 r r r r a,,~( \sf |
  \times 2/3 { a8[ \p bes) a] } \times 2/3 { g8-.[ f-. e-.] } \times 2/3 { d8([ cis) e-.] } |
  d4-. d-. e8.( \trill d32 e f4) f-. gis8.( \trill \< fis32 gis |
  a4) \f a-. a-. |

  d,-. a'-.

  bes \p r bes'( a) r a,( bes) \pp r gis( a) r a \f ||

}}

CelloIV = \new Voice { \relative c' {
  \set Staff.instrumentName = #"'Cello "
  \clef bass

  g4\p r r |
  c, r r |
  \crescTextCresc r8.. cis32( \< \downbow \stemUp d2) \stemNeutral |
  d8..( d'32) dis4. \f dis8 |

  e4( d) r |
  r8 c \p \< \noBeam c c c c |
  g[ \f g g g] c, c |
  g \p g g g c, c |

  d2. \< |
  g4 \f r8 g'-1 \p c, d |

  %%% K

  b'4( -\markup \italic "dolce" g8) r16. g32( b8. g16) |
  a8.( b64[ a gis a] c8-.) r16. \stemUp a,32( -\markup \teeny "III" e'8. c16) |
  b4.. \< a16 \stemNeutral c'8.-4( b16) |
  a4-4( g8) g-4( \f fis e) |

  a, \noBeam \p a' a a a a |
  a, \noBeam a' a a a a |
  a, \noBeam a' a \< a a a |
  a, \noBeam a' a a a a |
  a, \f \noBeam a' a a a a |

  a4~-2 \p a16( gis \< b a g-4 fis e d) |
  cis8-.-1 \p e-. a,-. r4. |
  a'4~ \p a16( gis \< b a g fis e d) |
  cis8-.-1 \p e-. a,-. r4. |

  d8 \< d d d d d |
  d d d \f d d d |
  g \p r a r a, r |

  \set crescendoText = \markup { \italic { cresc. \smaller "(espress.)" } }
  \set crescendoSpanner = #'text
  b16( b'-3) b \< b b( e,-1) e e e( g) g g |
  g-2( \f cis,) cis cis cis( e) e e e( d) d d |

  %%% L

  g,( g'-0) g g g8 r g \p r |
  \crescTextCresc g2~ \< g8 b-. \f |
  a-. \fp fis'-. d-. a-. \crescHairpin fis-.\< d-. |
  a a a \f a a a |

  d4 r g,8[ \ff r16 g'] |
  fis4( g8) r4. |
  r8 a,( \p \noBeam a') a a a |

  d,4. r8 g,[ \ff r16 g'] |
  fis4( g8) r4. |
  r8 a,( \p \noBeam a') a a a |

  d,4. r |

  %%% M

  fis4( -\markup \italic "(dolce)"  d8) r16. d32( fis8. d16) |
  g8.( \f a64[ \p g fis g-1] b8-.) r4. |
  e,4( cis8) r16. \stemUp cis32( e8. cis16) \stemNeutral |
  fis8.( \p g64[ \p fis e fis] a8-.) r4. |

  \crescTextCresc g8 [g] fis[ fis] c?[ c] |
  b[ b] e \f e e e |
  a \p r b r b, r |

  c16( c') \< c c c( fis,) fis fis fis( b) b b |
  b( e,) e e e( \f a) a a a( g) g g |
  a8 \p r b r b, r |

  c c c c cis cis |
  d d d d dis dis |
  e e \< e e e e |
  \dimHairpin fis16( g \f fis e) d( \> e d c) b( c b a) |

  %%% N

  g4 \p r r |
  c r r |
  r8.. \stemUp cis32( \downbow \< d2) \stemNeutral |
  d8..( d'32) dis4. \f dis8 |

  e4( d) r |
  r8*3/4 s32 \p c8 \noBeam c \< [c c c] |
  g \f [g g g] \noBeam c, c |
  g \p g g g c, c8*1/2 s16 \< |

  d2. |
  g4 \sf r8 \crescHairpin b'( \p \< c-1 d) |
  e4( \! -\markup \italic "(dolce)" c8) r16. c32( e16.[ c32 e16. c32]) |
  d8.( e64[ d cis d] f8-.) r16. d,32 \downbow bes'-2[( \( a16.) g32( f16.)] \) |

  e4..( d16) \crescTextCresc f'8.( \< e16) |
  d4( \f c8) \noBeam c,( b? a) |

  %%% O

  d, \p \noBeam d' d d d d |
  d, \noBeam d' d d d d |
  d, \noBeam d' \< d d d d |
  d, \noBeam d' d d d d |
  d, \f \noBeam d' d d d d |

  d4~ \p d16( \< cis e d c-4 b a g) |
  fis8-. \p a-. d,-. r4. |
  d''4~-2 \p d16( \< cis e d c-2 b a g-2) |
  fis8-. \p a-. d,-. r4. |

  g,8 \noBeam g' g \< g g g |
  g g g \f g g g |
  c \p r d r d, r |
  e16( e') \< e e e( a,) a a a ( c) c c |
  c( \f fis,) fis fis fis -1( a) a a a( g) g g |

  %%% P

  c,( c'-4) c c c8 \p r e r |
  d,16( \f d') d d d8 \p r f r |
  e,,16( \f e') e e e8 \p r g r |
  ees16( \f ees,) ees ees ees8 \p r ees'' r |

  r16 d,( \< d'8~ d16) d,( d'8~ d16) d,( \f d' d,) |
  d'8 r r4 r |
  d,,8 \p d d \< d d d |

  g4 \f r c,8[ \ff r16 c'] |
  b4( c8) r4. |
  r8 d,( \p \noBeam d') d d d |

  \override Beam #'auto-knee-gap = #4.5
  g,4. r8 c,8.-. \ff c''16 |  %%Kneed beam here, please
  b4( c8) r4. |
  d,,16( \p d') d d d( \< gis,) gis gis gis( b) b b |
  b( \f d,) d d d( g) g g g( b) b b |

  %%% Q

  c8 \p c c c c c |
  cis \< cis cis cis cis cis |
  d \! r r4 r |

  r16 d \p \downbow \< d( g) g( b,) b( d) d-. \f g,-. b-. cis,-. |
  d8 d' \p d r4. |
  d,16( \p c'-0) c c c( fis,-1) fis( a) a( d,) d( fis-3) |

  g4 r d'( \p |
  g8) r r4 d4( |
  g,8) r r \clef tenor g''-.( \pp g-. g-.) |
  g4 r r ||

}}

CelloV = \new Voice { \relative c' {
  \set Staff.instrumentName = #"'Cello "
  \clef bass

  R2*20 |
  \crescTextCresc

  %%% R

  R2 |
  \times 2/3 { a8-2([ \f gis b] } \times 2/3 { a8[ g-1 fis-4)] } |
  \times 2/3 { e8([ dis fis] } e8) r |
  \times 2/3 { g8-2([ fis a] } g8) r |
  R2 |

  \times 2/3 { b8-3([ a c] } \times 2/3 { b8[ a g-4)] } |
  \times 2/3 { fis8([ e g] } fis8) r |
  \times 2/3 { a-2([ gis b] } a8) r |
  R2 |

  \times 2/3 { c8-2([ b d] } \times 2/3 { c8[ b a)] } |
  \times 2/3 { g?8-2([ fis a] } g8) r |
  \times 2/3 { b8-3([ a c] } b8) r |
  R2 |

  \times 2/3 { d8-2([ cis? e] } \times 2/3 { d8-4[ cis b)] } |
  a2 |
  \times 2/3 { d8([ cis e] } \times 2/3 { d8[ cis b)] } |
  a2 |

  \times 2/3 { d8([ cis e] } \times 2/3 { d[ c bes)] } |
  a4 r |
  a8-.-1( \p r a-.) r |
  a4 r |
  a,-.( \pp a-.) |
  a2 \fermata ||

  %% No more tripolets for a while!

  d,8 \p \repeat unfold 15 d' |
  d, \repeat unfold 15 d' |
  d2( g,) a( b) fis( g a) |

  d8-. d-. fis-. a-. |
  d2( g,) a( b) |

  %%% S

  fis( g a) |
  b( c \< b a) \f |
  b8 b b b b b a a gis gis b b gis gis e e |
  a2~ \p a |

  a,~ ^\markup \number 1
  a~ ^\markup \number 2
  a~ ^\markup \number 3
  a~ ^\markup \number 4
  a~ ^\markup \number 5
  a~ ^\markup \number 6
  a~ ^\markup \number 7
  a~ ^\markup \number 8

  a'~ a~ a4 a, |
  a'2~ a~ a~ a4 a, |

  \times 2/3 { bes'8-2([ \f a c] } \times 2/3 { bes8[ a g)] } |
  f2 f,~ f4 f' f f |

  %%% T

  e r r \times 2/3 { r8 gis,-._4 \p fis?-. } |
  \times 2/3 { e8-.[ b'-._4 a-.] } \times 2/3 { gis8-.[ d'-._4 cis?-.] } |
  \times 2/3 { b8-.[ fis'-.-3 e-.] } \times 2/3 { d8-. b'-.-4 a-.] } |
  gis4( \f a8) \p r |

  r4 \times 2/3 { r8 gis,-. \p fis-. } |
  \times 2/3 { e8-.[ b'-. a-.] } \times 2/3 { gis8-.[ d'-. cis-.] } |
  \times 2/3 { b8-.[ fis'-. e-.] } \times 2/3 { d8-.[ b'-. a-.] } |
  gis4( \f a8) \p r |

  R2*4 |
  cis,2( \sf |
  d4) \p d e e, a r |
  R2*3 |

  \times 2/3 { r8 e''-4( \f d } \times 2/3 { cis8)[ \p a-.-4 gis-.] } |
  \times 2/3 { fis8-.[ e-.-4 d-.] } \times 2/3 { cis8-.[ b-._4 a-.] } |
  gis4 r |
  R2 |

  \times 2/3 { r8 \upbow e''-4( \f d } \times 2/3 { cis8)[ \p a-. gis-.] } |
  \times 2/3 { fis8-.[ e-. d-.] } \times 2/3 { cis8-.[ b-. a-.] } |
  d2~ d |
  dis~ \< dis |
  e4 \f r e r e r e,2( |

  %%% U

  a8) \noBeam a'[ \p a a] |
  \repeat unfold 12 a |
  a4 d,( e) e |
  a,8 \noBeam a'[ a a] |
  \repeat percent 5 { a a a a } |
  a4 d, e e |

  a,2~ ^\markup \number 1
  a~ ^\markup \number 2
  a~ ^\markup \number 3
  a~ ^\markup \number 4
  a8 r r4 |

  a'8-.( \p r a-.) r a4 r a8-.( r a-.) r a4 r a8-.( r a-.) r d4 r |

  %% Repeat here

  d8-.( \p \< r d-.) r d4 r |
  d8-.( r d-.) r d4 \f r d r d r |

  s2 %% Grand Pause

  g,,8 \p \noBeam g'[ g g] |
  \repeat unfold 12 g |
  g, \noBeam g'[ g g] |
  \repeat unfold 12 g |

  g2( c,) d4( dis e d) |
  c2( d) e4( eis fis) r |
  R2*2 |

  %%% V

  \times 2/3 { e8-2([ \f dis fis] } \times 2/3 { e8[ d-0 cis-4)] } b2 |
  \times 2/3 { d8-2([ cis e] } \times 2/3 { d8[ cis b)] } a2 |
  \times 2/3 { c8-2([ b d] } \times 2/3 { c8[ b a] } g2( fis) |
  f( e) ees( d) cis?4 r |

  r8 fis16-1( cis' e8) e-. |
  e-2( \trill dis) dis4 |

  r8 e,16-1( b' d8) e-. |
  d-2( \trill cis) cis4 |

  r \p d, d'2~ d~ d~ d4 d, d'2~ d~ d~ d4 d, d' r |
  R2*11 |

  %%% W

  R2 |
  \times 2/3 { a'8-3([ \f g bes] } \times 2/3 { a8[ g f)] } |
  \times 2/3 { e8([ d f] } e8) r |
  \times 2/3 { g8([ fis a] } g8) r |
  R2 |

  \times 2/3 { bes8([ a c] } \times 2/3 { bes[ a g)] } |
  \times 2/3 { f8([ e g] } f8 r |
  \times 2/3 { a8([ g bes] } a8) r |
  R2 |

  \times 2/3 { a8([ bes d] } \times 2/3 { c8[ bes a)] } |
  g2~ \times 2/3 { g8([ e g] } \times 2/3 { f[ e d)] } |
  c4 g'~
  \times 2/3 { g8([ e g] } \times 2/3 { f[ e d)] } |
  c4 r c'8-.( \p r c-.) r |
  c4 r c,-.( \pp c-.) c2 \fermata |

  f,8 \p \noBeam f'[ f f] |
  \repeat unfold 12 f |
  f,8 \noBeam f'[ f f] |
  \repeat unfold 12 f |

  f2~ \f \times 2/3 { f8([ e g] } \times 2/3 { f?[ e d)] } |
  c2~-2 \times 2/3 { c8([ b d] } \times 2/3 { c?8[ bes-2 a)] } |
  g4 g'~-2 \times 2/3 { g8([ fis? a] } \times 2/3 { g[ f-2 e)] } |
  d2~ \times 2/3 { d8([ cis?-1 e] } \times 2/3 { b8[ c b?_3)] } |

  a4 b-1 | e, fis | b cis-2 | fis, gis | cis r | R2 |
  b4~ \upbow \times 2/3 { b8([ cis dis)] } |
  e4~ \times 2/3 { e8([ fis gis)] } |
  a4~ \times 2/3 { a8([ b cis)] } |
  d2~ \p d~ d~ d4 d, d'2~ d~ d~ d4 d, |

  \clef tenor \times 2/3 { ees'8-2([ \f d f] } \times 2/3 { ees8[ d c-2)] } |
  bes2 \clef bass bes,~ bes4 bes' bes bes |

  %%% X

  a r r \times 2/3 { r8 cis,?-._4 \p b?-. } |
  \times 2/3 { a8-. [ e'-._4 d-.] } \times 2/3 { cis8-.[ g'-.-4 fis-.] } \times 2/3 { e8-.[ b'-.-4 a-.] } \times 2/3 { g8-. e'-.-4 d-. } cis4( \f d8) \p r |
  r4 \times 2/3 { r8 cis,-. \p b-. } \times 2/3 { a8-.[ e'-. d-.] } \times 2/3 { cis8-.[ g'-. fis-.] } \times 2/3 { e8-.[ b'-. a-.] } \times 2/3 { g8-.[ e'-. d-.] } cis4( \f d8) \p r |
  R2*4 |

  fis,,2( \sf g4) \p g' a a, d r |
  R2*3 |
  \times 2/3 { r8 a'-4( \f g } \times 2/3 { fis8)[ \p d-.-4 cis-.] } \times 2/3 { b8-.[ a-._1 g-.] } \times 2/3 { fis8-.[ e-. d-.-2] } cis4 r R2 |
  \clef tenor \times 2/3 { r8*3/4 s32 \upbow a'''8-3( \f g-. } \times 2/3 { fis-1)[ \p d-.-4 cis-.] } | 
  \clef bass \times 2/3 { b8-.[ a-. g-.] } \times 2/3 { fis8-.[ e-. d-.] } |
  g2~ g gis~ \< gis a4 \f r a r a r | a,2( |

  d8) d'\p d d \repeat unfold 12 d |
  d4 g,( a) a, |

  %%% Y

  \repeat unfold 8 d8 | g, g g g a a a a b \< b b b cis cis cis cis d d d d e e e e fis fis fis fis g g g g |
  a4( \f ais b \p g) | a? r a, r |
  d,2~ \f d d'~ d d'4 r |

  %% Repeat's end

  \repeat unfold 2 { R2*3 s2 }
  \times 2/3 { c8([ \p b d] } \times 2/3 { c8[ a g)] } \times 2/3 { fis8([ e g] } fis8) r |
  \times 2/3 { gis8([ fis a] } gis8 r | \times 2/3 { e8([ \< dis fis] } e8) r | \times 2/3 { fis8([ e g?] } fis8) r |
  g2~ \f g a4 a a a |

  %%% Z

  a2( \p gis) g( \< fis) g4 \f r R2 |
  a,4 a a( g) fis2~ \p fis cis'~ cis d4 g, a2 |

  \times 2/3 { d'8-2([ \f cis e] } \times 2/3 { d8[ cis b-4)] } |
  \times 2/3 { a8([ gis b] } \times 2/3 { a8[ g-1 fis-4)] } |
  \times 2/3 { e8([ dis fis] } \times 2/3 { e8[ d-0 cis-4)] } |
  \times 2/3 { b8([ ais cis] } \times 2/3 { b8[ a g)] } |

  fis4 r gis r | a2~ \p a d4 r |
  R2*4 |
  d4 \p d a r a a d r a \f r d, r ||

}}

%**********************************

musicI = {
  <<
    \tag #'score \tag #'vn1 \new Staff { << \globalI \ViolinOneI >> }
    \tag #'score \tag #'vn2 \new Staff { << \globalI \ViolinTwoI >> }
    \tag #'score \tag #'vla \new Staff { << \globalI \ViolaI >> }
    \tag #'score \tag #'vlc \new Staff { << \globalI \CelloI >> }
  >>
}

musicII= {
  <<
    \tag #'score \tag #'vn1 \new Staff { << \globalII \ViolinOneII >> }
    \tag #'score \tag #'vn2 \new Staff { << \globalII \ViolinTwoII >> }
    \tag #'score \tag #'vla \new Staff { << \globalII \ViolaII >> }
    \tag #'score \tag #'vlc \new Staff { << \globalII \CelloII >> }
  >>
}

musicIII = {
  <<
    \tag #'score \tag #'vn1 \new Staff { << \globalIII \ViolinOneIII >> }
    \tag #'score \tag #'vn2 \new Staff { << \globalIII \ViolinTwoIII >> }
    \tag #'score \tag #'vla \new Staff { << \globalIII \ViolaIII >> }
    \tag #'score \tag #'vlc \new Staff { << \globalIII \CelloIII >> }
  >>
}

musicIV = {
  <<
    \tag #'score \tag #'vn1 \new Staff { << \globalIV \ViolinOneIV >> }
    \tag #'score \tag #'vn2 \new Staff { << \globalIV \ViolinTwoIV >> }
    \tag #'score \tag #'vla \new Staff { << \globalIV \ViolaIV >> }
    \tag #'score \tag #'vlc \new Staff { << \globalIV \CelloIV >> }
  >>
}

musicV = {
  <<
    \tag #'score \tag #'vn1 \new Staff { << \globalV \ViolinOneV >> }
    \tag #'score \tag #'vn2 \new Staff { << \globalV \ViolinTwoV >> }
    \tag #'score \tag #'vla \new Staff { << \globalV \ViolaV >> }
    \tag #'score \tag #'vlc \new Staff { << \globalV \CelloV >> }
  >>
}