%lastupdated = #(strftime "Fassung vom %d. %B %Y, %H:%M Uhr" (localtime (current-time)))
footer = #(strftime "Mutopia-%Y/%B/%d-xxx" (localtime (current-time)))

\version "2.12.2"

\header {
  filename      =       "let-chp-op-35-4-scholz-fi.ly"
  title         =       \markup \fontsize #1 { Sonate Nr. 2 b-moll }
  subtitle      =       \markup \fontsize #1 { 4. Satz }
  composer      =       \markup \large { "Frédéric Chopin (1810 - 1849)" }
  opus          =       \markup \center-align { \fontsize #-11 " " \normalsize "Opus 35" }
  enteredby     =       "Roland Goretzki"

 mutopiatitle = "Sonate 2 b-moll"
 mutopiacomposer = "ChopinFF"
 mutopiaopus = "Op. 35"
 mutopiainstrument = "Piano"
 date = "1837-1839"
 source = "Peters, Herrmann Scholtz, 1900c"
 style = "Romantic"
 copyright = "Public Domain"
 maintainer = "Roland Goretzki"
 maintainerEmail = "roland@roland-goretzki.de"
 maintainerWeb = "http://www.roland-goretzki.de/"
 lastupdated = "2009/Nov/04"

 footer = "Mutopia-2009/11/30-1727"
 tagline = \markup { \override #'(box-padding . 1.0) \override #'(baseline-skip . 2.7) \box \center-column { \small \line { Sheet music from \with-url #"http://www.MutopiaProject.org" \line { \teeny www. \hspace #-1.0 MutopiaProject \hspace #-1.0 \teeny .org \hspace #0.5 } • \hspace #0.5 \italic Free to download, with the \italic freedom to distribute, modify and perform. } \line { \small \line { Typeset using \with-url #"http://www.LilyPond.org" \line { \teeny www. \hspace #-1.0 LilyPond \hspace #-1.0 \teeny .org } by \maintainer \hspace #-1.0 . \hspace #0.5 Reference: \footer } } \line { \teeny \line { This sheet music has been placed in the public domain by the typesetter, for details see: \hspace #-0.5 \with-url #"http://creativecommons.org/licenses/publicdomain" http://creativecommons.org/licenses/publicdomain } } } }
}

\include "deutsch.ly"
#(set-global-staff-size 18.2)

#(set-default-paper-size "letter")
\paper{
  top-margin = .6\cm
  left-margin = 1.1\cm
  line-width = 19.59\cm
  paper-width = 8.5\in
  paper-height = 11\in
  indent = .7\cm
  print-first-page-number = ##t
  print-page-number = ##t
  ragged-bottom=##f
  ragged-last-bottom=##f
  bottom-margin = .6\cm
}

global = {
       \set GrandStaff.autoAccidentals = #`(Voice ,(make-accidental-rule 'same-octave 0))
       \set GrandStaff.autoAccidentals = #`(Voice ,(make-accidental-rule 'any-octave 0)
                                            ,(make-accidental-rule 'same-octave 1)
                                       Staff
                                            ,(make-accidental-rule 'same-octave 0)
                                            ,(make-accidental-rule 'any-octave 0)
                                            ,(make-accidental-rule 'same-octave 1)
                                       GrandStaff
                                            ,(make-accidental-rule 'any-octave 1)
                                            ,(make-accidental-rule 'same-octave 1))
  \set Staff.extraNatural = ##f
  #(override-auto-beam-setting '(end * * * *) 1 4 'Staff)
  #(override-auto-beam-setting '(end * * * *) 1 2 'Staff)
  #(override-auto-beam-setting '(end * * * *) 3 4 'Staff)
  \override Score.TupletBracket #'bracket-visibility = ##f
  \override Score.TupletNumber #'transparent = ##t
  \key b \minor \time 2/2 s1* 77 \bar "|."
}

rechts = {
\override Score.VerticalAxisGroup #'remove-first = ##t
  \once\override Score.RehearsalMark #'extra-offset = #'(0 . 2)
  \override Score.RehearsalMark #'self-alignment-X = #'-1
    \mark \markup { \bold \large { \column { Finale. Presto. } } }
  \set tupletSpannerDuration = #(ly:make-moment 1 4)
  \clef bass
  \times 2/3 {
f%Note
8%Dauer
^1%Finger
g%Note
^2%Finger
b%Note
^3%Finger
des'%Note
^5%Finger
e%Note
^1%Finger
g%Note
%^0%Finger
f%Note
^1%Finger
g%Note
%^0%Finger
b%Note
%^0%Finger
des'%Note
%^0%Finger
e%Note
^1%Finger
g%Note
%^0%Finger
g%Note
^1%Finger
a%Note
^2%Finger
c'%Note
^3%Finger
es'%Note
^5%Finger
fis%Note
^1%Finger
a%Note
%^0%Finger
g%Note
^1%Finger
a%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
fis%Note
^1%Finger
a%Note
%^0%Finger
% Takt  2
\clef violin
b%Note
^1%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
ges'%Note
^5%Finger
a%Note
^1%Finger
c'%Note
^2%Finger
des'%Note
^1%Finger
es'%Note
%^0%Finger
ges'%Note
%^0%Finger
a'%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
^1%Finger
es'%Note
%^0%Finger
ges'%Note
%^0%Finger
a'%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
^2%Finger
ges'%Note
^1%Finger
b'%Note
%^0%Finger
c''%Note
%^0%Finger
es''%Note
%^0%Finger
f'%Note
%^0%Finger
a'%Note
^2%Finger
% Takt  4
b'%Note
^1%Finger
des''%Note
%^0%Finger
ges''%Note
%^0%Finger
f''%Note
%^0%Finger
c''%Note
^1%Finger
des''%Note
^3%Finger
fes''%Note
^5%Finger
c''%Note
^2%Finger
des''%Note
^3%Finger
a'%Note
^1%Finger
b'%Note
^4%Finger
ges'%Note
^2%Finger
e'%Note
^1%Finger
f'%Note
%^0%Finger
b'%Note
^5%Finger
gis'%Note
^3%Finger
a'%Note
^1%Finger
des''%Note
^4%Finger
a'%Note
%^0%Finger
b'%Note
%^0%Finger
des''%Note
^3%Finger
h'%Note
^1%Finger
c''%Note
%^0%Finger
f''%Note
%^0%Finger
as'%Note
^1%Finger
ces''%Note
%^0%Finger
fes''%Note
^5%Finger
es''%Note
^4%Finger
b'%Note
^2%Finger
ces''%Note
^1%Finger
eses''%Note
^5%Finger
b'%Note
^2%Finger
ces''%Note
%^0%Finger
g'%Note
^1%Finger
as'%Note
^4%Finger
fes'%Note
^2%Finger
d'%Note
^1%Finger
es'%Note
%^0%Finger
as'%Note
%^0%Finger
e'%Note
^1%Finger
f'%Note
%^0%Finger
ces''%Note
^5%Finger
f'%Note
^1%Finger
ges'%Note
%^0%Finger
ces''%Note
^4%Finger
a'%Note
^1%Finger
b'%Note
%^0%Finger
es''%Note
^5%Finger
% Takt  8
des''%Note
^4%Finger
f'%Note
^1%Finger
b'%Note
^3%Finger
cis'%Note
^1%Finger
e'%Note
%^0%Finger
a'%Note
^4%Finger
c''%Note
%^0%Finger
es'%Note
^2%Finger
as'%Note
^3%Finger
h%Note
^1%Finger
d'%Note
%^0%Finger
g'%Note
^4%Finger
ces''%Note
%^0%Finger
eses'%Note
^2%Finger
ges'%Note
^3%Finger
b%Note
^1%Finger
des'%Note
%^0%Finger
ges'%Note
^4%Finger
b'%Note
^5%Finger
ges'%Note
^2%Finger
ces''%Note
^4%Finger
c''%Note
^1%Finger
des''%Note
^3%Finger
es''%Note
%^0%Finger
e''%Note
^5%Finger
g'%Note
^2%Finger
c''%Note
%^0%Finger
es'%Note
^1%Finger
ges'%Note
%^0%Finger
ces''%Note
^4%Finger
d''%Note
%^0%Finger
f'%Note
^2%Finger
b'%Note
%^0%Finger
cis'%Note
^1%Finger
e'%Note
%^0%Finger
a'%Note
^4%Finger
% Takt 11
c''%Note
%^0%Finger
es'%Note
%^0%Finger
as'%Note
^4%Finger
h%Note
%^0%Finger
d'%Note
%^0%Finger
g'%Note
^4%Finger
h'%Note
^5%Finger
fis'%Note
^2%Finger
cis''%Note
^4%Finger
d''%Note
^1%Finger
es''%Note
^3%Finger
e''%Note
%^0%Finger
% Takt 12
f''%Note
%^0%Finger
a'%Note
%^0%Finger
es''%Note
^2%Finger
e''%Note
^3%Finger
f''%Note
%^0%Finger
ges''%Note
%^0%Finger
f''%Note
%^0%Finger
b'%Note
%^0%Finger
des''%Note
^2%Finger
e''%Note
^3%Finger
f''%Note
^4%Finger
fis''%Note
^3%Finger
g''%Note
^4%Finger
h'%Note
%^0%Finger
f''%Note
^2%Finger
fis''%Note
%^0%Finger
g''%Note
%^0%Finger
as''%Note
%^0%Finger
g''%Note
%^0%Finger
c''%Note
%^0%Finger
es''%Note
^2%Finger
fis''%Note
%^0%Finger
g''%Note
%^0%Finger
as''%Note
%^0%Finger
% Takt 14
es''%Note
%^0%Finger
c''%Note
%^0%Finger
f''%Note
^4%Finger
es''%Note
%^0%Finger
as'%Note
%^0%Finger
des''%Note
^4%Finger
c''%Note
%^0%Finger
es'%Note
%^0%Finger
b'%Note
^4%Finger
as'%Note
%^0%Finger
c'%Note
%^0%Finger
f'%Note
^4%Finger
% Takt 15
es'%Note
%^0%Finger
as%Note
%^0%Finger
des'%Note
^4%Finger
\clef bass
c'%Note
%^0%Finger
g%Note
%^0%Finger
as%Note
%^0%Finger
c'%Note
^4%Finger
fis%Note
%^0%Finger
d'%Note
%^0%Finger
c'%Note
%^0%Finger
eis%Note
^1%Finger
fis%Note
%^0%Finger
g%Note
^3%Finger
a%Note
^1%Finger
h%Note
%^0%Finger
\clef violin
c'%Note
%^0%Finger
d'%Note
%^0%Finger
es'%Note
%^0%Finger
as%Note
^1%Finger
b%Note
%^0%Finger
h%Note
^1%Finger
c'%Note
%^0%Finger
des'%Note
%^0%Finger
es'%Note
%^0%Finger
% Takt 17
a%Note
^1%Finger
b%Note
%^0%Finger
c'%Note
^1%Finger
des'%Note
^3%Finger
es'%Note
%^0%Finger
f'%Note
%^0%Finger
b%Note
^2%Finger
h%Note
^1%Finger
c'%Note
%^0%Finger
des'%Note
%^0%Finger
es'%Note
%^0%Finger
f'%Note
%^0%Finger
c'%Note
^1%Finger
des'%Note
%^0%Finger
d'%Note
^1%Finger
es'%Note
^3%Finger
f'%Note
%^0%Finger
ges'%Note
%^0%Finger
heses%Note
%^0%Finger
des'%Note
^2%Finger
d'%Note
%^0%Finger
es'%Note
^4%Finger
f'%Note
^1%Finger
ges'%Note
%^0%Finger
heses'%Note
^4%Finger
ges'%Note
^2%Finger
fes'%Note
^1%Finger
eses'%Note
^2%Finger
fes'%Note
%^0%Finger
ges'%Note
%^0%Finger
heses%Note
%^0%Finger
des'%Note
^2%Finger
d'%Note
%^0%Finger
e'%Note
^4%Finger
f'%Note
^1%Finger
ges'%Note
%^0%Finger
% Takt 20
heses'%Note
^4%Finger
as'%Note
%^0%Finger
g'%Note
^1%Finger
ges'%Note
^3%Finger
es'%Note
%^0%Finger
c'%Note
%^0%Finger
ges'%Note
^4%Finger
es'%Note
^2%Finger
c'%Note
^1%Finger
b%Note
^4%Finger
a%Note
%^0%Finger
as%Note
%^0%Finger
% Takt 21
\clef bass
g%Note
^1%Finger
as%Note
^3%Finger
heses%Note
%^0%Finger
f%Note
^1%Finger
ges%Note
^3%Finger
as%Note
%^0%Finger
e%Note
^1%Finger
f%Note
^3%Finger
ges%Note
%^0%Finger
d%Note
^1%Finger
e%Note
^4%Finger
f%Note
%^0%Finger
g,%Note
^1%Finger
as,%Note
%^0%Finger
b,%Note
%^0%Finger
c%Note
^1%Finger
des%Note
%^0%Finger
es%Note
%^0%Finger
f%Note
^1%Finger
ges%Note
%^0%Finger
g%Note
%^0%Finger
as%Note
%^0%Finger
f%Note
%^0%Finger
b%Note
^3%Finger
as%Note
%^0%Finger
f'%Note
^5%Finger
es'%Note
^3%Finger
des'%Note
%^0%Finger
c'%Note
%^0%Finger
b%Note
^4%Finger
as%Note
%^0%Finger
f%Note
%^0%Finger
ges%Note
%^0%Finger
as%Note
%^0%Finger
f%Note
%^0%Finger
b%Note
^4%Finger
% Takt 24
as%Note
%^0%Finger
es%Note
^1%Finger
f%Note
%^0%Finger
ges%Note
%^0%Finger
es%Note
%^0%Finger
b%Note
^5%Finger
as%Note
%^0%Finger
des%Note
^1%Finger
es%Note
%^0%Finger
f%Note
%^0%Finger
des%Note
%^0%Finger
b%Note
^5%Finger
as%Note
%^0%Finger
c%Note
%^0%Finger
des%Note
%^0%Finger
es%Note
%^0%Finger
c%Note
%^0%Finger
f%Note
^4%Finger
es%Note
%^0%Finger
b,%Note
%^0%Finger
f%Note
^5%Finger
es%Note
%^0%Finger
as,%Note
^1%Finger
b,%Note
^3%Finger
% Takt 26
as,%Note
^2%Finger
des%Note
^4%Finger
es%Note
^5%Finger
f%Note
^1%Finger
ges%Note
%^0%Finger
as%Note
%^0%Finger
\clef violin
b%Note
%^0%Finger
c'%Note
^1%Finger
des'%Note
%^0%Finger
es'%Note
%^0%Finger
f'%Note
^4%Finger
ges'%Note
^1%Finger
% Takt 27
as'%Note
%^0%Finger
f''%Note
^5%Finger
es''%Note
^3%Finger
des''%Note
%^0%Finger
c''%Note
%^0%Finger
b'%Note
^4%Finger
as'%Note
%^0%Finger
f'%Note
%^0%Finger
ges'%Note
%^0%Finger
as'%Note
%^0%Finger
f'%Note
%^0%Finger
b'%Note
^4%Finger
% Takt 28
as'%Note
%^0%Finger
es'%Note
^1%Finger
f'%Note
%^0%Finger
ges'%Note
%^0%Finger
es'%Note
%^0%Finger
b'%Note
^5%Finger
as'%Note
%^0%Finger
des'%Note
^1%Finger
es'%Note
%^0%Finger
f'%Note
%^0%Finger
des'%Note
%^0%Finger
b'%Note
%^0%Finger
as'%Note
^4%Finger
c'%Note
%^0%Finger
des'%Note
%^0%Finger
es'%Note
%^0%Finger
c'%Note
%^0%Finger
f'%Note
^4%Finger
es'%Note
%^0%Finger
b%Note
^1%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
as%Note
%^0%Finger
f'%Note
^4%Finger
% Takt 30
ges'%Note
%^0%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
c'%Note
^1%Finger
b%Note
^2%Finger
a%Note
%^0%Finger
f'%Note
%^0%Finger
c'%Note
^2%Finger
es'%Note
^4%Finger
des'%Note
%^0%Finger
b%Note
^2%Finger
a%Note
%^0%Finger
f'%Note
%^0%Finger
c'%Note
^2%Finger
es'%Note
^4%Finger
des'%Note
%^0%Finger
b%Note
%^0%Finger
a%Note
%^0%Finger
f'%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
b%Note
^1%Finger
% Takt 32
as'%Note
^5%Finger
g'%Note
%^0%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
d'%Note
^1%Finger
c'%Note
^2%Finger
h%Note
%^0%Finger
g'%Note
%^0%Finger
d'%Note
^2%Finger
f'%Note
^4%Finger
es'%Note
%^0%Finger
c'%Note
^2%Finger
h%Note
%^0%Finger
g'%Note
%^0%Finger
d'%Note
%^0%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
c'%Note
%^0%Finger
h%Note
%^0%Finger
g'%Note
%^0%Finger
d'%Note
%^0%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
c'%Note
%^0%Finger
% Takt 34
des''%Note
^5%Finger
c''%Note
%^0%Finger
b'%Note
%^0%Finger
as'%Note
%^0%Finger
g'%Note
^1%Finger
f'%Note
^2%Finger
b'%Note
^4%Finger
e'%Note
^1%Finger
g'%Note
^5%Finger
des'%Note
^2%Finger
e'%Note
^3%Finger
c'%Note
^1%Finger
des''%Note
^5%Finger
c''%Note
%^0%Finger
b'%Note
%^0%Finger
as'%Note
%^0%Finger
g'%Note
%^0%Finger
f'%Note
^2%Finger
b'%Note
^4%Finger
e'%Note
^1%Finger
g'%Note
^5%Finger
des'%Note
^2%Finger
e'%Note
%^0%Finger
c'%Note
%^0%Finger
% Takt 36
b'%Note
%^0%Finger
e'%Note
^2%Finger
g'%Note
%^0%Finger
des'%Note
%^0%Finger
e'%Note
%^0%Finger
c'%Note
%^0%Finger
g'%Note
^5%Finger
des'%Note
^2%Finger
e'%Note
%^0%Finger
c'%Note
^1%Finger
e'%Note
^4%Finger
b%Note
^2%Finger
% Takt 37
e'%Note
^5%Finger
b%Note
%^0%Finger
des'%Note
%^0%Finger
\clef bass
a%Note
^1%Finger
b%Note
^3%Finger
as%Note
^2%Finger
des'%Note
^5%Finger
as%Note
%^0%Finger
b%Note
%^0%Finger
g%Note
^1%Finger
b%Note
^4%Finger
ges%Note
^2%Finger
% Takt 38
f%Note
8%Dauer
^1%Finger
g%Note
%^0%Finger
b%Note
%^0%Finger
des'%Note
%^0%Finger
e%Note
^1%Finger
g%Note
%^0%Finger
f%Note
^1%Finger
g%Note
%^0%Finger
b%Note
%^0%Finger
des'%Note
%^0%Finger
e%Note
^1%Finger
g%Note
%^0%Finger
g%Note
^1%Finger
a%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
fis%Note
^1%Finger
a%Note
%^0%Finger
g%Note
^1%Finger
a%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
fis%Note
^1%Finger
a%Note
%^0%Finger
% Takt  2 <--> Takt 40
\clef violin
b%Note
^1%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
ges'%Note
%^0%Finger
a%Note
^1%Finger
c'%Note
^2%Finger
des'%Note
^1%Finger
es'%Note
%^0%Finger
ges'%Note
%^0%Finger
a'%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
^1%Finger
es'%Note
%^0%Finger
ges'%Note
%^0%Finger
a'%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
^2%Finger
ges'%Note
^1%Finger
b'%Note
%^0%Finger
c''%Note
%^0%Finger
es''%Note
%^0%Finger
f'%Note
%^0%Finger
a'%Note
^2%Finger
% Takt  4 <--> Takt 42
b'%Note
^1%Finger
des''%Note
%^0%Finger
ges''%Note
%^0%Finger
f''%Note
%^0%Finger
c''%Note
^1%Finger
des''%Note
^3%Finger
fes''%Note
^5%Finger
c''%Note
^2%Finger
des''%Note
^3%Finger
a'%Note
^1%Finger
b'%Note
^4%Finger
ges'%Note
^2%Finger
% Takt  5 <--> Takt 43
e'%Note
^1%Finger
f'%Note
%^0%Finger
b'%Note
^5%Finger
gis'%Note
^3%Finger
a'%Note
^1%Finger
des''%Note
^4%Finger
a'%Note
%^0%Finger
b'%Note
%^0%Finger
des''%Note
^3%Finger
h'%Note
^1%Finger
c''%Note
%^0%Finger
f''%Note
%^0%Finger
as'%Note
^1%Finger
ces''%Note
%^0%Finger
fes''%Note
^5%Finger
es''%Note
^4%Finger
b'%Note
^2%Finger
ces''%Note
^1%Finger
eses''%Note
^5%Finger
b'%Note
^2%Finger
ces''%Note
%^0%Finger
g'%Note
^1%Finger
as'%Note
^4%Finger
fes'%Note
^2%Finger
d'%Note
^1%Finger
es'%Note
%^0%Finger
as'%Note
%^0%Finger
e'%Note
^1%Finger
f'%Note
%^0%Finger
ces''%Note
^5%Finger
f'%Note
^1%Finger
ges'%Note
%^0%Finger
ces''%Note
^4%Finger
a'%Note
^1%Finger
b'%Note
%^0%Finger
es''%Note
^5%Finger
% Takt  8 <--> Takt 46
des''%Note
^4%Finger
f'%Note
^1%Finger
b'%Note
^3%Finger
cis'%Note
^1%Finger
e'%Note
%^0%Finger
a'%Note
^4%Finger
c''%Note
%^0%Finger
es'%Note
^2%Finger
as'%Note
^3%Finger
h%Note
^1%Finger
d'%Note
%^0%Finger
g'%Note
^4%Finger
ces''%Note
^5%Finger
eses'%Note
^2%Finger
ges'%Note
^3%Finger
b%Note
^1%Finger
des'%Note
%^0%Finger
ges'%Note
^4%Finger
b'%Note
^5%Finger
ges'%Note
^2%Finger
ces''%Note
^4%Finger
c''%Note
^1%Finger
des''%Note
^3%Finger
es''%Note
%^0%Finger
% Takt 10 vom Einsatz, also eigentlich Takt 48
des''%Note
%^0%Finger
c''%Note
%^0%Finger
ces''%Note
%^0%Finger
b'%Note
^2%Finger
a'%Note
%^0%Finger
f''%Note
^5%Finger
es''%Note
%^0%Finger
d''%Note
%^0%Finger
des''%Note
%^0%Finger
c''%Note
^1%Finger
b'%Note
^2%Finger
ges''%Note
^5%Finger
% Takt 49
f''%Note
%^0%Finger
es''%Note
%^0%Finger
d''%Note
^1%Finger
des''%Note
^2%Finger
c''%Note
%^0%Finger
a''%Note
%^0%Finger
c''%Note
^1%Finger
des''%Note
%^0%Finger
b''%Note
%^0%Finger
d''%Note
^1%Finger
es''%Note
%^0%Finger
b''%Note
^4%Finger
c'''%Note
%^0%Finger
b''%Note
%^0%Finger
as''%Note
%^0%Finger
ges''%Note
%^0%Finger
f''%Note
^1%Finger
e''%Note
^2%Finger
c'''%Note
^5%Finger
b''%Note
%^0%Finger
as''%Note
%^0%Finger
ges''%Note
%^0%Finger
f''%Note
^1%Finger
e''%Note
^2%Finger
% Takt 51
ges''%Note
^4%Finger
f''%Note
%^0%Finger
e''%Note
^1%Finger
es''%Note
^3%Finger
d''%Note
^1%Finger
des''%Note
^3%Finger
es''%Note
%^0%Finger
h'%Note
%^0%Finger
c''%Note
^3%Finger
des''%Note
%^0%Finger
a'%Note
%^0%Finger
b'%Note
^3%Finger
% Takt 52
c''%Note
%^0%Finger
g'%Note
%^0%Finger
as'%Note
%^0%Finger
ces''%Note
^3%Finger
ges'%Note
%^0%Finger
es''%Note
%^0%Finger
b'%Note
^2%Finger
f'%Note
%^0%Finger
ges'%Note
%^0%Finger
a'%Note
^3%Finger
e'%Note
%^0%Finger
cis''%Note
%^0%Finger
gis'%Note
^3%Finger
dis'%Note
^1%Finger
e'%Note
%^0%Finger
g'%Note
%^0%Finger
d'%Note
%^0%Finger
h'%Note
%^0%Finger
fis'%Note
^2%Finger
cis'%Note
^1%Finger
d'%Note
%^0%Finger
f'%Note
^3%Finger
c'%Note
%^0%Finger
a'%Note
^5%Finger
% Takt' 54
d''%Note
^4%Finger
a'%Note
^1%Finger
b'%Note
%^0%Finger
des''%Note
^3%Finger
as'%Note
%^0%Finger
f''%Note
%^0%Finger
c''%Note
^2%Finger
g'%Note
%^0%Finger
as'%Note
%^0%Finger
ces''%Note
^3%Finger
ges'%Note
%^0%Finger
es''%Note
%^0%Finger
b'%Note
^2%Finger
f'%Note
%^0%Finger
ges'%Note
%^0%Finger
a'%Note
^3%Finger
e'%Note
%^0%Finger
cis''%Note
%^0%Finger
gis'%Note
^2%Finger
dis'%Note
^1%Finger
e'%Note
%^0%Finger
g'%Note
^3%Finger
d'%Note
%^0%Finger
h'%Note
^5%Finger
% Takt 56
e''%Note
^4%Finger
h'%Note
%^0%Finger
c''%Note
%^0%Finger
es''%Note
^3%Finger
b'%Note
%^0%Finger
g''%Note
%^0%Finger
d''%Note
^2%Finger
a'%Note
%^0%Finger
b'%Note
%^0%Finger
des''%Note
^3%Finger
as'%Note
%^0%Finger
f''%Note
%^0%Finger
c''%Note
^2%Finger
g'%Note
%^0%Finger
as'%Note
%^0%Finger
ces''%Note
^3%Finger
ges'%Note
%^0%Finger
es''%Note
%^0%Finger
b'%Note
^2%Finger
f'%Note
%^0%Finger
es''%Note
%^0%Finger
b'%Note
^3%Finger
f'%Note
%^0%Finger
des''%Note
^5%Finger
% Takt 58
ges'%Note
^2%Finger
f'%Note
%^0%Finger
fes'%Note
^4%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
c'%Note
%^0%Finger
ges'%Note
^5%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
c'%Note
^1%Finger
b%Note
^2%Finger
ges'%Note
^5%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
c'%Note
%^0%Finger
ces'%Note
^2%Finger
ges'%Note
^5%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
ces'%Note
^1%Finger
b%Note
^2%Finger
% Takt' 60
\clef bass
a%Note
^1%Finger
b%Note
%^0%Finger
c'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
a%Note
%^0%Finger
c'%Note
^4%Finger
b%Note
%^0%Finger
f%Note
%^0%Finger
as%Note
^4%Finger
ges%Note
%^0%Finger
f%Note
%^0%Finger
% Takt 61
es%Note
^1%Finger
f%Note
%^0%Finger
ges%Note
^3%Finger
b%Note
^5%Finger
as%Note
%^0%Finger
ges%Note
%^0%Finger
f%Note
^2%Finger
des%Note
^1%Finger
es%Note
%^0%Finger
f%Note
%^0%Finger
e%Note
^1%Finger
f%Note
%^0%Finger
% Takt 62
ges%Note
%^0%Finger
f%Note
%^0%Finger
e%Note
%^0%Finger
es%Note
^3%Finger
des%Note
%^0%Finger
c%Note
%^0%Finger
ges%Note
^5%Finger
f%Note
%^0%Finger
es%Note
%^0%Finger
des%Note
%^0%Finger
c%Note
%^0%Finger
b,%Note
^2%Finger
ges%Note
^5%Finger
f%Note
%^0%Finger
es%Note
%^0%Finger
des%Note
%^0%Finger
c%Note
%^0%Finger
ces%Note
^2%Finger
ges%Note
^5%Finger
f%Note
%^0%Finger
es%Note
%^0%Finger
des%Note
%^0%Finger
ces%Note
%^0%Finger
b,%Note
^2%Finger
% Takt 64
a,%Note
%^0%Finger
b,%Note
%^0%Finger
ces%Note
^1%Finger
des%Note
%^0%Finger
es%Note
%^0%Finger
f%Note
^1%Finger
ges%Note
%^0%Finger
as%Note
%^0%Finger
b%Note
%^0%Finger
ces'%Note
^1%Finger
des'%Note
%^0%Finger
es'%Note
%^0%Finger
f'%Note
^5%Finger
e'%Note
^4%Finger
des'%Note
^2%Finger
c'%Note
^1%Finger
b%Note
^4%Finger
ges%Note
^2%Finger
f%Note
%^0%Finger
e%Note
^3%Finger
des%Note
%^0%Finger
c%Note
%^0%Finger
b,%Note
^4%Finger
ges,%Note
^2%Finger
% Takt 66
f,%Note
%^0%Finger
b,%Note
^3%Finger
gis,%Note
^2%Finger
a,%Note
^1%Finger
des%Note
^4%Finger
a,%Note
%^0%Finger
b,%Note
%^0%Finger
es%Note
^4%Finger
h,%Note
^1%Finger
c%Note
%^0%Finger
f%Note
^5%Finger
c%Note
^1%Finger
des%Note
%^0%Finger
ges%Note
^4%Finger
d%Note
^1%Finger
es%Note
%^0%Finger
a%Note
%^0%Finger
f%Note
^1%Finger
ges%Note
%^0%Finger
des'%Note
%^0%Finger
a%Note
^1%Finger
\clef violin
c'%Note
^2%Finger
ges'%Note
%^0%Finger
f'%Note
%^0%Finger
% Takt 68
a%Note
^1%Finger
des'%Note
^3%Finger
a%Note
%^0%Finger
c'%Note
^2%Finger
ges'%Note
%^0%Finger
f'%Note
%^0%Finger
a%Note
%^0%Finger
des'%Note
%^0%Finger
a%Note
%^0%Finger
c'%Note
%^0%Finger
ges'%Note
^5%Finger
f'%Note
^3%Finger
c'%Note
^1%Finger
ges'%Note
^4%Finger
f'%Note
%^0%Finger
c'%Note
%^0%Finger
ges'%Note
%^0%Finger
f'%Note
%^0%Finger
c'%Note
%^0%Finger
ges'%Note
%^0%Finger
f'%Note
%^0%Finger
b%Note
^1%Finger
ges'%Note
^5%Finger
f'%Note
%^0%Finger
% Takt 70
des'%Note
^2%Finger
f%Note
%^0%Finger
es'%Note
^4%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
b%Note
^2%Finger
f%Note
%^0%Finger
c'%Note
^3%Finger
des'%Note
^4%Finger
c'%Note
%^0%Finger
b%Note
%^0%Finger
des'%Note
^3%Finger
f%Note
%^0%Finger
es'%Note
^4%Finger
f'%Note
%^0%Finger
es'%Note
%^0%Finger
des'%Note
%^0%Finger
b%Note
%^0%Finger
f%Note
%^0%Finger
c'%Note
^4%Finger
des'%Note
%^0%Finger
c'%Note
%^0%Finger
b%Note
%^0%Finger
% Takt 72
\clef bass
es%Note
^1%Finger
f%Note
%^0%Finger
b%Note
^4%Finger
des'%Note
%^0%Finger
des%Note
%^0%Finger
f%Note
%^0%Finger
es%Note
^1%Finger
f%Note
%^0%Finger
b%Note
%^0%Finger
des'%Note
%^0%Finger
des%Note
%^0%Finger
f%Note
%^0%Finger
c%Note
^1%Finger
des%Note
%^0%Finger
f%Note
%^0%Finger
b%Note
^5%Finger
b,%Note
%^0%Finger
des%Note
%^0%Finger
c%Note
%^0%Finger
des%Note
%^0%Finger
f%Note
%^0%Finger
b%Note
%^0%Finger
b,%Note
%^0%Finger
des%Note
%^0%Finger
% Takt 74
}
r2
\times 2/3 {
c%Note
8%Dauer
%^0%Finger
des%Note
%^0%Finger
f%Note
%^0%Finger
b%Note
%^0%Finger
b,%Note
%^0%Finger
des%Note
%^0%Finger
% Takt 75
}
r2
\times 2/3 {
c%Note
8%Dauer
%^0%Finger
des%Note
%^0%Finger
f%Note
%^0%Finger
b%Note
%^0%Finger
b,%Note
%^0%Finger
des%Note
%^0%Finger
  }
% Takt 76
r2
\clef violin
<b'' b'''>
\fermata
}

links = {
  \times 2/3 {
f%Note
8%Dauer
_4%Finger
g%Note
_3%Finger
b%Note
_2%Finger
des'%Note
_1%Finger
e%Note
_5%Finger
g%Note
%0%Finger
f%Note
_4%Finger
g%Note
%0%Finger
b%Note
%0%Finger
des'%Note
%0%Finger
e%Note
%0%Finger
g%Note
%0%Finger
g%Note
_4%Finger
a%Note
_3%Finger
c'%Note
_2%Finger
es'%Note
_1%Finger
fis%Note
_5%Finger
a%Note
%0%Finger
g%Note
_4%Finger
a%Note
%0%Finger
c'%Note
%0%Finger
es'%Note
%0%Finger
fis%Note
_5%Finger
a%Note
_3%Finger
% Takt  2
b%Note
_2%Finger
c'%Note
_1%Finger
es'%Note
_2%Finger
ges'%Note
_1%Finger
a%Note
_5%Finger
c'%Note
_3%Finger
des'%Note
_2%Finger
es'%Note
_1%Finger
ges'%Note
_2%Finger
a'%Note
%0%Finger
c'%Note
%0%Finger
es'%Note
_3%Finger
des'%Note
_4%Finger
es'%Note
%0%Finger
ges'%Note
%0%Finger
a'%Note
%0%Finger
c'%Note
_5%Finger
es'%Note
_3%Finger
ges'%Note
_2%Finger
b'%Note
_1%Finger
c''%Note
_2%Finger
es''%Note
_1%Finger
f'%Note
_5%Finger
a'%Note
_3%Finger
% Takt  4
b'%Note
_2%Finger
des''%Note
_1%Finger
ges''%Note
_2%Finger
f''%Note
_1%Finger
c''%Note
_4%Finger
des''%Note
%0%Finger
fes''%Note
%0%Finger
c''%Note
_3%Finger
des''%Note
%0%Finger
a'%Note
_5%Finger
b'%Note
_2%Finger
ges'%Note
_3%Finger
e'%Note
_5%Finger
f'%Note
%0%Finger
b'%Note
_1%Finger
gis'%Note
_3%Finger
a'%Note
%0%Finger
des''%Note
_1%Finger
a'%Note
_4%Finger
b'%Note
%0%Finger
des''%Note
_2%Finger
h'%Note
_4%Finger
c''%Note
%0%Finger
f''%Note
%0%Finger
as'%Note
_5%Finger
ces''%Note
%0%Finger
fes''%Note
%0%Finger
es''%Note
%0%Finger
b'%Note
_4%Finger
ces''%Note
%0%Finger
eses''%Note
%0%Finger
b'%Note
_3%Finger
ces''%Note
%0%Finger
g'%Note
_5%Finger
as'%Note
_2%Finger
fes'%Note
_4%Finger
d'%Note
_5%Finger
es'%Note
%0%Finger
as'%Note
_2%Finger
e'%Note
_4%Finger
f'%Note
%0%Finger
ces''%Note
%0%Finger
f'%Note
_4%Finger
ges'%Note
%0%Finger
ces''%Note
%0%Finger
a'%Note
_5%Finger
b'%Note
%0%Finger
es''%Note
_2%Finger
% Takt  8
des''%Note
_1%Finger
f'%Note
_5%Finger
b'%Note
_2%Finger
cis'%Note
%0%Finger
e'%Note
_4%Finger
a'%Note
%0%Finger
c''%Note
%0%Finger
es'%Note
_3%Finger
as'%Note
%0%Finger
h%Note
%0%Finger
d'%Note
_4%Finger
g'%Note
%0%Finger
ces''%Note
%0%Finger
eses'%Note
_3%Finger
ges'%Note
%0%Finger
b%Note
%0%Finger
des'%Note
_4%Finger
ges'%Note
%0%Finger
b'%Note
%0%Finger
ges'%Note
_4%Finger
ces''%Note
_2%Finger
c''%Note
%0%Finger
des''%Note
_3%Finger
es''%Note
%0%Finger
e''%Note
%0%Finger
g'%Note
_4%Finger
c''%Note
%0%Finger
es'%Note
%0%Finger
ges'%Note
_4%Finger
ces''%Note
%0%Finger
d''%Note
%0%Finger
f'%Note
_3%Finger
b'%Note
_2%Finger
cis'%Note
_5%Finger
e'%Note
_4%Finger
a'%Note
_2%Finger
% Takt 11
c''%Note
%0%Finger
es'%Note
_4%Finger
as'%Note
%0%Finger
h%Note
%0%Finger
d'%Note
_4%Finger
g'%Note
%0%Finger
h'%Note
_1%Finger
fis'%Note
_5%Finger
cis''%Note
_2%Finger
d''%Note
%0%Finger
es''%Note
_3%Finger
e''%Note
%0%Finger
% Takt 12
\clef violin
f''%Note
%0%Finger
a'%Note
%0%Finger
es''%Note
_3%Finger
e''%Note
%0%Finger
f''%Note
%0%Finger
ges''%Note
_2%Finger
f''%Note
_1%Finger
b'%Note
%0%Finger
des''%Note
%0%Finger
e''%Note
%0%Finger
f''%Note
%0%Finger
fis''%Note
_2%Finger
g''%Note
%0%Finger
h'%Note
%0%Finger
f''%Note
_3%Finger
fis''%Note
%0%Finger
g''%Note
%0%Finger
as''%Note
_2%Finger
g''%Note
_1%Finger
c''%Note
%0%Finger
es''%Note
%0%Finger
fis''%Note
_2%Finger
g''%Note
%0%Finger
as''%Note
_2%Finger
% Takt 14
es''%Note
%0%Finger
c''%Note
%0%Finger
f''%Note
_1%Finger
es''%Note
%0%Finger
as'%Note
%0%Finger
des''%Note
_1%Finger
\clef bass
c''%Note
%0%Finger
es'%Note
%0%Finger
b'%Note
_1%Finger
as'%Note
%0%Finger
c'%Note
%0%Finger
f'%Note
_1%Finger
es'%Note
%0%Finger
as%Note
%0%Finger
des'%Note
_3%Finger
c'%Note
_1%Finger
g%Note
_4%Finger
as%Note
%0%Finger
c'%Note
%0%Finger
fis%Note
_5%Finger
d'%Note
%0%Finger
c'%Note
%0%Finger
eis%Note
_5%Finger
fis%Note
%0%Finger
g%Note
%0%Finger
a%Note
%0%Finger
h%Note
%0%Finger
c'%Note
_3%Finger
d'%Note
%0%Finger
es'%Note
%0%Finger
as%Note
_4%Finger
b%Note
%0%Finger
h%Note
%0%Finger
c'%Note
%0%Finger
des'%Note
_3%Finger
es'%Note
%0%Finger
% Takt 17
a%Note
_5%Finger
b%Note
_4%Finger
c'%Note
_1%Finger
des'%Note
_3%Finger
es'%Note
%0%Finger
f'%Note
%0%Finger
b%Note
_4%Finger
h%Note
%0%Finger
c'%Note
_1%Finger
des'%Note
_3%Finger
es'%Note
%0%Finger
f'%Note
%0%Finger
c'%Note
_4%Finger
des'%Note
%0%Finger
d'%Note
_1%Finger
es'%Note
_3%Finger
f'%Note
%0%Finger
ges'%Note
%0%Finger
heses%Note
_5%Finger
des'%Note
_3%Finger
d'%Note
_1%Finger
es'%Note
_4%Finger
f'%Note
%0%Finger
ges'%Note
%0%Finger
heses'%Note
%0%Finger
ges'%Note
_2%Finger
fes'%Note
%0%Finger
eses'%Note
_4%Finger
fes'%Note
%0%Finger
ges'%Note
%0%Finger
heses%Note
_5%Finger
des'%Note
_3%Finger
d'%Note
%0%Finger
e'%Note
_1%Finger
f'%Note
_3%Finger
ges'%Note
%0%Finger
% Takt 20
heses'%Note
%0%Finger
as'%Note
%0%Finger
g'%Note
_1%Finger
ges'%Note
%0%Finger
es'%Note
%0%Finger
c'%Note
%0%Finger
ges'%Note
%0%Finger
es'%Note
%0%Finger
c'%Note
_1%Finger
b%Note
%0%Finger
a%Note
_1%Finger
as%Note
%0%Finger
% Takt 21
g%Note
%0%Finger
as%Note
%0%Finger
heses%Note
%0%Finger
f%Note
_4%Finger
ges%Note
%0%Finger
as%Note
%0%Finger
e%Note
_5%Finger
f%Note
_3%Finger
ges%Note
%0%Finger
d%Note
_5%Finger
e%Note
_3%Finger
f%Note
_1%Finger
g,%Note
_5%Finger
as,%Note
_3%Finger
b,%Note
%0%Finger
c%Note
%0%Finger
des%Note
_3%Finger
es%Note
%0%Finger
f%Note
%0%Finger
ges%Note
_4%Finger
g%Note
%0%Finger
as%Note
%0%Finger
f%Note
%0%Finger
b%Note
_2%Finger
as%Note
%0%Finger
f'%Note
_1%Finger
es'%Note
%0%Finger
des'%Note
%0%Finger
c'%Note
_1%Finger
b%Note
%0%Finger
as%Note
%0%Finger
f%Note
%0%Finger
ges%Note
%0%Finger
as%Note
%0%Finger
f%Note
%0%Finger
b%Note
_1%Finger
% Takt 24
as%Note
%_0%Finger
es%Note
%_0%Finger
f%Note
%_0%Finger
ges%Note
%_0%Finger
es%Note
%_0%Finger
b%Note
_1%Finger
as%Note
%_0%Finger
des%Note
%_0%Finger
es%Note
%_0%Finger
f%Note
%_0%Finger
des%Note
%_0%Finger
b%Note
%_0%Finger
as%Note
%_0%Finger
c%Note
%_0%Finger
des%Note
%_0%Finger
es%Note
%_0%Finger
c%Note
%_0%Finger
f%Note
_1%Finger
es%Note
%_0%Finger
b,%Note
_4%Finger
f%Note
%_0%Finger
es%Note
%_0%Finger
as,%Note
_5%Finger
b,%Note
%_0%Finger
% Takt 26
as,%Note
%_0%Finger
des%Note
_3%Finger
es%Note
%_0%Finger
f%Note
%_0%Finger
ges%Note
_4%Finger
as%Note
%_0%Finger
b%Note
%_0%Finger
c'%Note
%_0%Finger
des'%Note
_3%Finger
es'%Note
%_0%Finger
f'%Note
%_0%Finger
ges'%Note
_4%Finger
% Takt 27
as'%Note
%_0%Finger
f''%Note
%_0%Finger
es''%Note
%_0%Finger
des''%Note
%_0%Finger
c''%Note
_1%Finger
b'%Note
%_0%Finger
as'%Note
%_0%Finger
f'%Note
%_0%Finger
ges'%Note
%_0%Finger
as'%Note
%_0%Finger
f'%Note
%_0%Finger
b'%Note
_1%Finger
% Takt 28
as'%Note
%_0%Finger
es'%Note
_5%Finger
f'%Note
%_0%Finger
ges'%Note
%_0%Finger
es'%Note
%_0%Finger
b'%Note
%_0%Finger
as'%Note
%_0%Finger
des'%Note
_5%Finger
es'%Note
%_0%Finger
f'%Note
%_0%Finger
des'%Note
%_0%Finger
b'%Note
%_0%Finger
as'%Note
%_0%Finger
c'%Note
_5%Finger
des'%Note
%_0%Finger
es'%Note
%_0%Finger
c'%Note
%_0%Finger
f'%Note
_1%Finger
es'%Note
_2%Finger
b%Note
_4%Finger
f'%Note
%_0%Finger
es'%Note
%_0%Finger
as%Note
_5%Finger
f'%Note
_1%Finger
% Takt 30
ges'%Note
_2%Finger
f'%Note
_1%Finger
es'%Note
%_0%Finger
des'%Note
%_0%Finger
c'%Note
_1%Finger
b%Note
_4%Finger
a%Note
%_0%Finger
f'%Note
%_0%Finger
c'%Note
%_0%Finger
es'%Note
_1%Finger
des'%Note
%_0%Finger
b%Note
_4%Finger
a%Note
%_0%Finger
f'%Note
%_0%Finger
c'%Note
%_0%Finger
es'%Note
%_0%Finger
des'%Note
%_0%Finger
b%Note
%_0%Finger
a%Note
%_0%Finger
f'%Note
%_0%Finger
c'%Note
%_0%Finger
es'%Note
%_0%Finger
des'%Note
%_0%Finger
b%Note
_5%Finger
% Takt 32
as'%Note
_1%Finger
g'%Note
%_0%Finger
f'%Note
_1%Finger
es'%Note
%_0%Finger
d'%Note
%_0%Finger
c'%Note
%_0%Finger
h%Note
_5%Finger
g'%Note
%_0%Finger
d'%Note
_3%Finger
f'%Note
_1%Finger
es'%Note
%_0%Finger
c'%Note
_4%Finger
h%Note
%_0%Finger
g'%Note
%_0%Finger
d'%Note
%_0%Finger
f'%Note
_1%Finger
es'%Note
%_0%Finger
c'%Note
_4%Finger
h%Note
%_0%Finger
g'%Note
%_0%Finger
d'%Note
%_0%Finger
f'%Note
_1%Finger
es'%Note
_3%Finger
c'%Note
_5%Finger
% Takt 34
des''%Note
_1%Finger
c''%Note
%_0%Finger
b'%Note
%_0%Finger
as'%Note
_4%Finger
g'%Note
_1%Finger
f'%Note
_4%Finger
b'%Note
_2%Finger
e'%Note
_5%Finger
g'%Note
_1%Finger
des'%Note
_4%Finger
e'%Note
_2%Finger
c'%Note
_5%Finger
des''%Note
_1%Finger
c''%Note
%_0%Finger
b'%Note
%_0%Finger
as'%Note
%_0%Finger
g'%Note
_1%Finger
f'%Note
_4%Finger
b'%Note
_2%Finger
e'%Note
_5%Finger
g'%Note
_1%Finger
des'%Note
_4%Finger
e'%Note
_2%Finger
c'%Note
_5%Finger
% Takt 36
b'%Note
_1%Finger
e'%Note
_3%Finger
g'%Note
%_0%Finger
des'%Note
_4%Finger
e'%Note
%_0%Finger
c'%Note
%_0%Finger
g'%Note
_1%Finger
des'%Note
%_0%Finger
e'%Note
%_0%Finger
c'%Note
%_0%Finger
e'%Note
%_0%Finger
b%Note
%_0%Finger
% Takt 37
e'%Note
_1%Finger
b%Note
_3%Finger
des'%Note
_2%Finger
a%Note
_4%Finger
b%Note
%_0%Finger
as%Note
_5%Finger
des'%Note
_1%Finger
as%Note
_3%Finger
b%Note
%_0%Finger
g%Note
_4%Finger
b%Note
_2%Finger
ges%Note
_3%Finger
% Takt 38
f%Note
8%Dauer
_4%Finger
g%Note
%_0%Finger
b%Note
%_0%Finger
des'%Note
%_0%Finger
e%Note
_5%Finger
g%Note
%_0%Finger
f%Note
_4%Finger
g%Note
%_0%Finger
b%Note
%_0%Finger
des'%Note
%_0%Finger
e%Note
%_0%Finger
g%Note
%_0%Finger
g%Note
_4%Finger
a%Note
%_0%Finger
c'%Note
%_0%Finger
es'%Note
%_0%Finger
fis%Note
_5%Finger
a%Note
%_0%Finger
g%Note
_4%Finger
a%Note
%_0%Finger
c'%Note
%_0%Finger
es'%Note
%_0%Finger
fis%Note
_5%Finger
a%Note
_3%Finger
% Takt  2
b%Note
_2%Finger
c'%Note
_1%Finger
es'%Note
_2%Finger
ges'%Note
_1%Finger
a%Note
_5%Finger
c'%Note
_3%Finger
des'%Note
_2%Finger
es'%Note
_1%Finger
ges'%Note
_2%Finger
a'%Note
%_0%Finger
c'%Note
%_0%Finger
es'%Note
_3%Finger
des'%Note
_4%Finger
es'%Note
%_0%Finger
ges'%Note
%_0%Finger
a'%Note
%_0%Finger
c'%Note
%_0%Finger
es'%Note
%_0%Finger
ges'%Note
_2%Finger
b'%Note
_1%Finger
c''%Note
_2%Finger
es''%Note
_1%Finger
f'%Note
_5%Finger
a'%Note
_3%Finger
% Takt 42
b'%Note
_2%Finger
des''%Note
_1%Finger
ges''%Note
_2%Finger
f''%Note
_1%Finger
c''%Note
_4%Finger
des''%Note
%_0%Finger
fes''%Note
%_0%Finger
c''%Note
_3%Finger
des''%Note
%_0%Finger
a'%Note
_5%Finger
b'%Note
_2%Finger
ges'%Note
_3%Finger
e'%Note
_5%Finger
f'%Note
%_0%Finger
b'%Note
_1%Finger
gis'%Note
_3%Finger
a'%Note
%_0%Finger
des''%Note
_1%Finger
a'%Note
_4%Finger
b'%Note
%_0%Finger
des''%Note
_2%Finger
h'%Note
_4%Finger
c''%Note
%_0%Finger
f''%Note
%_0%Finger
as'%Note
_5%Finger
ces''%Note
%_0%Finger
fes''%Note
%_0%Finger
es''%Note
%_0%Finger
b'%Note
_4%Finger
ces''%Note
%_0%Finger
eses''%Note
%_0%Finger
b'%Note
_3%Finger
ces''%Note
%_0%Finger
g'%Note
_5%Finger
as'%Note
_2%Finger
fes'%Note
_4%Finger
d'%Note
_5%Finger
es'%Note
%_0%Finger
as'%Note
_2%Finger
e'%Note
_4%Finger
f'%Note
%_0%Finger
ces''%Note
%_0%Finger
f'%Note
_4%Finger
ges'%Note
%_0%Finger
ces''%Note
%_0%Finger
a'%Note
_5%Finger
b'%Note
%_0%Finger
es''%Note
_2%Finger
% Takt 46
des''%Note
_1%Finger
f'%Note
_5%Finger
b'%Note
_2%Finger
cis'%Note
%_0%Finger
e'%Note
_4%Finger
a'%Note
%_0%Finger
c''%Note
%_0%Finger
es'%Note
_3%Finger
as'%Note
%_0%Finger
h%Note
%_0%Finger
d'%Note
_4%Finger
g'%Note
%_0%Finger
ces''%Note
%_0%Finger
eses'%Note
%_0%Finger
ges'%Note
%_0%Finger
b%Note
%_0%Finger
des'%Note
%_0%Finger
ges'%Note
%_0%Finger
b'%Note
_1%Finger
ges'%Note
_3%Finger
ces''%Note
_1%Finger
c''%Note
_4%Finger
des''%Note
%_0%Finger
es''%Note
%_0%Finger
% Takt 10 vom Einsatz, also eigentlich Takt 48
des''%Note
%_0%Finger
c''%Note
_1%Finger
ces''%Note
%_0%Finger
b'%Note
%_0%Finger
a'%Note
%_0%Finger
f''%Note
%_0%Finger
es''%Note
%_0%Finger
d''%Note
_1%Finger
des''%Note
_2%Finger
\clef violin
c''%Note
%_0%Finger
b'%Note
%_0%Finger
ges''%Note
_2%Finger
% Takt 49
f''%Note
_1%Finger
es''%Note
%_0%Finger
d''%Note
%_0%Finger
des''%Note
_4%Finger
c''%Note
%_0%Finger
a''%Note
%_0%Finger
c''%Note
%_0%Finger
des''%Note
%_0%Finger
b''%Note
%_0%Finger
d''%Note
_5%Finger
es''%Note
%_0%Finger
b''%Note
_2%Finger
c'''%Note
%_0%Finger
b''%Note
%_0%Finger
as''%Note
%_0%Finger
ges''%Note
_4%Finger
f''%Note
_1%Finger
e''%Note
_5%Finger
c'''%Note
%_0%Finger
b''%Note
%_0%Finger
as''%Note
%_0%Finger
ges''%Note
%_0%Finger
f''%Note
_1%Finger
e''%Note
_4%Finger
% Takt 51
ges''%Note
_2%Finger
f''%Note
_1%Finger
e''%Note
%_0%Finger
es''%Note
%_0%Finger
d''%Note
_1%Finger
des''%Note
_3%Finger
es''%Note
%_0%Finger
h'%Note
_4%Finger
c''%Note
%_0%Finger
des''%Note
_2%Finger
a'%Note
_5%Finger
b'%Note
_3%Finger
% Takt 52
\clef bass
c''%Note
_1%Finger
g'%Note
_4%Finger
as'%Note
%_0%Finger
ces''%Note
_2%Finger
ges'%Note
%_0%Finger
es''%Note
%_0%Finger
b'%Note
_2%Finger
f'%Note
%_0%Finger
ges'%Note
%_0%Finger
a'%Note
_2%Finger
e'%Note
%_0%Finger
cis''%Note
%_0%Finger
gis'%Note
_2%Finger
dis'%Note
%_0%Finger
e'%Note
%_0%Finger
g'%Note
_2%Finger
d'%Note
%_0%Finger
h'%Note
%_0%Finger
fis'%Note
_2%Finger
cis'%Note
%_0%Finger
d'%Note
%_0%Finger
f'%Note
_2%Finger
c'%Note
%_0%Finger
a'%Note
_1%Finger
% Takt' 54
d''%Note
_2%Finger
a'%Note
%_0%Finger
b'%Note
%_0%Finger
des''%Note
_2%Finger
as'%Note
%_0%Finger
f''%Note
%_0%Finger
c''%Note
_2%Finger
g'%Note
%_0%Finger
as'%Note
%_0%Finger
ces''%Note
_2%Finger
ges'%Note
%_0%Finger
es''%Note
%_0%Finger
b'%Note
_2%Finger
f'%Note
%_0%Finger
ges'%Note
%_0%Finger
a'%Note
_2%Finger
e'%Note
%_0%Finger
cis''%Note
%_0%Finger
gis'%Note
_2%Finger
dis'%Note
%_0%Finger
e'%Note
%_0%Finger
g'%Note
_2%Finger
d'%Note
%_0%Finger
h'%Note
_1%Finger
% Takt 56
e''%Note
_2%Finger
h'%Note
%_0%Finger
c''%Note
%_0%Finger
es''%Note
_2%Finger
b'%Note
%_0%Finger
g''%Note
%_0%Finger
d''%Note
_2%Finger
a'%Note
%_0%Finger
b'%Note
%_0%Finger
des''%Note
_2%Finger
as'%Note
%_0%Finger
f''%Note
%_0%Finger
c''%Note
%_0%Finger
g'%Note
%_0%Finger
as'%Note
%_0%Finger
ces''%Note
_2%Finger
ges'%Note
%_0%Finger
es''%Note
%_0%Finger
b'%Note
_3%Finger
f'%Note
%_0%Finger
es''%Note
%_0%Finger
b'%Note
_2%Finger
f'%Note
%_0%Finger
des''%Note
%_0%Finger
% Takt 58
ges'%Note
_3%Finger
f'%Note
_1%Finger
fes'%Note
%_0%Finger
es'%Note
%_0%Finger
des'%Note
%_0%Finger
c'%Note
%_0%Finger
ges'%Note
_2%Finger
f'%Note
_1%Finger
es'%Note
%_0%Finger
des'%Note
%_0%Finger
c'%Note
%_0%Finger
b%Note
%_0%Finger
ges'%Note
_2%Finger
f'%Note
_1%Finger
es'%Note
%_0%Finger
des'%Note
%_0%Finger
c'%Note
%_0%Finger
ces'%Note
%_0%Finger
ges'%Note
_2%Finger
f'%Note
_1%Finger
es'%Note
%_0%Finger
des'%Note
%_0%Finger
ces'%Note
_1%Finger
b%Note
_3%Finger
% Takt' 60
a%Note
%_0%Finger
b%Note
%_0%Finger
c'%Note
_2%Finger
es'%Note
_1%Finger
des'%Note
%_0%Finger
a%Note
%_0%Finger
c'%Note
_1%Finger
b%Note
%_0%Finger
f%Note
_5%Finger
as%Note
_2%Finger
ges%Note
%_0%Finger
f%Note
%_0%Finger
% Takt 61
es%Note
_5%Finger
f%Note
%_0%Finger
ges%Note
%_0%Finger
b%Note
_1%Finger
as%Note
%_0%Finger
ges%Note
%_0%Finger
f%Note
_1%Finger
des%Note
_3%Finger
es%Note
%_0%Finger
f%Note
%_0%Finger
e%Note
_4%Finger
f%Note
%_0%Finger
% Takt 62
ges%Note
_2%Finger
f%Note
_1%Finger
e%Note
%_0%Finger
es%Note
%_0%Finger
des%Note
%_0%Finger
c%Note
%_0%Finger
ges%Note
_2%Finger
f%Note
_1%Finger
es%Note
%_0%Finger
des%Note
%_0%Finger
c%Note
%_0%Finger
b,%Note
%_0%Finger
ges%Note
_2%Finger
f%Note
_1%Finger
es%Note
%_0%Finger
des%Note
%_0%Finger
c%Note
%_0%Finger
ces%Note
%_0%Finger
ges%Note
_2%Finger
f%Note
_1%Finger
es%Note
%_0%Finger
des%Note
%_0%Finger
ces%Note
_1%Finger
b,%Note
%_0%Finger
% Takt 64
a,%Note
%_0%Finger
b,%Note
%_0%Finger
ces%Note
%_0%Finger
des%Note
_3%Finger
es%Note
%_0%Finger
f%Note
%_0%Finger
ges%Note
_4%Finger
as%Note
%_0%Finger
b%Note
%_0%Finger
ces'%Note
%_0%Finger
des'%Note
_3%Finger
es'%Note
%_0%Finger
f'%Note
%_0%Finger
e'%Note
%_0%Finger
des'%Note
%_0%Finger
c'%Note
_1%Finger
b%Note
_2%Finger
ges%Note
_4%Finger
f%Note
_1%Finger
e%Note
%_0%Finger
des%Note
%_0%Finger
c%Note
_1%Finger
b,%Note
%_0%Finger
ges,%Note
_4%Finger
% Takt 66
f,%Note
%_0%Finger
b,%Note
_2%Finger
gis,%Note
_4%Finger
a,%Note
%_0%Finger
des%Note
_1%Finger
a,%Note
_4%Finger
b,%Note
%_0%Finger
es%Note
_1%Finger
h,%Note
_4%Finger
c%Note
%_0%Finger
f%Note
_1%Finger
c%Note
_4%Finger
des%Note
%_0%Finger
ges%Note
_1%Finger
d%Note
_4%Finger
es%Note
%_0%Finger
a%Note
%_0%Finger
f%Note
_4%Finger
ges%Note
%_0%Finger
des'%Note
%_0%Finger
a%Note
_5%Finger
c'%Note
_3%Finger
ges'%Note
_1%Finger
f'%Note
%_0%Finger
% Takt 68
a%Note
_5%Finger
des'%Note
_3%Finger
a%Note
%_0%Finger
c'%Note
_4%Finger
ges'%Note
%_0%Finger
f'%Note
%_0%Finger
a%Note
%_0%Finger
des'%Note
%_0%Finger
a%Note
%_0%Finger
c'%Note
%_0%Finger
ges'%Note
%_0%Finger
f'%Note
%_0%Finger
c'%Note
_4%Finger
ges'%Note
%_0%Finger
f'%Note
%_0%Finger
c'%Note
%_0%Finger
ges'%Note
%_0%Finger
f'%Note
%_0%Finger
c'%Note
%_0%Finger
ges'%Note
%_0%Finger
f'%Note
%_0%Finger
b%Note
%_0%Finger
ges'%Note
_2%Finger
f'%Note
_1%Finger
% Takt 70
des'%Note
_2%Finger
f%Note
%_0%Finger
es'%Note
%_0%Finger
\change Staff = up \stemDown \once\override Beam #'positions = #'(3 . 2.5)
f'%Note
%_0%Finger
\change Staff = down \stemUp
es'%Note
_1%Finger
des'%Note
%_0%Finger
b%Note
_3%Finger
f%Note
_5%Finger
c'%Note
_1%Finger
des'%Note
_2%Finger
c'%Note
_1%Finger
b%Note
_3%Finger
des'%Note
_2%Finger
f%Note
%_0%Finger
es'%Note
%_0%Finger
\change Staff = up \stemDown \once\override Beam #'positions = #'(3 . 2.5)
f'%Note
%_0%Finger
\change Staff = down \stemUp
es'%Note
_1%Finger
des'%Note
%_0%Finger
b%Note
_3%Finger
f%Note
%_0%Finger
c'%Note
_1%Finger
des'%Note
_2%Finger
c'%Note
_1%Finger
b%Note
_2%Finger
% Takt 72
es%Note
_4%Finger
f%Note
%_0%Finger
b%Note
%_0%Finger
des'%Note
%_0%Finger
des%Note
_5%Finger
f%Note
_3%Finger
es%Note
_4%Finger
f%Note
%_0%Finger
b%Note
%_0%Finger
des'%Note
%_0%Finger
des%Note
_4%Finger
f%Note
%_0%Finger
c%Note
_5%Finger
des%Note
%_0%Finger
f%Note
%_0%Finger
b%Note
%_0%Finger
b,%Note
_5%Finger
des%Note
_3%Finger
c%Note
_4%Finger
des%Note
%_0%Finger
f%Note
%_0%Finger
b%Note
%_0%Finger
b,%Note
%_0%Finger
des%Note
%_0%Finger
% Takt 74
}
r2
\times 2/3 {
c%Note
8%Dauer
_4%Finger
des%Note
%_0%Finger
f%Note
%_0%Finger
b%Note
%_0%Finger
b,%Note
%_0%Finger
des%Note
%_0%Finger
% Takt 75
}
r2
\times 2/3 {
c%Note
8%Dauer
_4%Finger
des%Note
%_0%Finger
f%Note
%_0%Finger
b%Note
%_0%Finger
b,%Note
%_0%Finger
des%Note
%_0%Finger
  }
% Takt 76
<b, b>
4
-.^>
\sustainOn
r
\once\override Staff.SustainPedal #'extra-offset = #'(3 . 0 )
<f' b' des'' f''>
2
^>
_\fermata
\sustainOff
}

Dynamik = {
s4-\markup { \italic\bold\fontsize #1.1 { sotto voce e legato } }
s2.
s1*12
s16 \< s8 s2. s16 \!
s16 \> s8 s2. s16 \!
s1*61
\once\override Staff.DynamicText #'extra-offset = #'(1 . 0 )
s4
\ff
}

zeilen = {
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\pageBreak
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break\pageBreak
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break
s1\noBreak      s1\noBreak      s1\break\pageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
s1\noBreak      s1\noBreak      s1\break\noPageBreak
}

\score {
  \new PianoStaff
  <<
    \context Staff = "up" << 
      \global
      \clef violin
      \rechts
      \zeilen
      \Dynamik
    >>
    \context Staff = "down" <<
      \global
      \clef bass
      \transpose c c, { \links }
    >>
  >>
}

\score {
  \new PianoStaff
  <<
    \context Staff = "up" << 
      \global
      \clef violin
      \rechts
    >>
    \context Staff = "down" <<
      \global
      \clef bass
      \transpose c c, { \links }
    >>
  >>
    \midi { \context { \Score tempoWholesPerMinute = #(ly:make-moment 112 2) } }
}
